/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.uncaughtexeptions;

import jakarta.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultUncaughtExceptionHandlerCreator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUncaughtExceptionHandlerCreator.class);

    public DefaultUncaughtExceptionHandlerCreator() {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            if (!(e instanceof ThreadDeath)) {
                this.defaultHandling(t, e);
                if (e instanceof OutOfMemoryError) {
                    this.outOfMemoryHandling(t);
                }
            }
        });
    }

    private void outOfMemoryHandling(Thread t) {
        LOG.error("OutOfMemoryError encountered in thread " + t.getName() + ", Graylog instance will be shut down.");
        Runtime runtime = Runtime.getRuntime();
        LOG.info("Free JVM memory : " + runtime.freeMemory());
        LOG.info("Total JVM memory : " + runtime.totalMemory());
        LOG.info("Max JVM memory : " + runtime.maxMemory());
        System.exit(1);
    }

    private void defaultHandling(Thread t, Throwable e) {
        System.err.print("Exception in thread \"" + t.getName() + "\" ");
        e.printStackTrace(System.err);
    }
}

