/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.lock;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.graylog2.cluster.lock.AlreadyLockedException;
import org.graylog2.cluster.lock.Lock;
import org.graylog2.cluster.lock.LockService;
import org.graylog2.shared.utilities.StringUtils;

public class RefreshingLockService
implements AutoCloseable {
    private final LockService lockService;
    private final ScheduledExecutorService scheduler;
    private final Duration lockTTL;
    private ScheduledFuture<?> lockRefreshFuture;
    private Lock lock;

    @Inject
    public RefreshingLockService(LockService lockService, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, @Named(value="lock_service_lock_ttl") Duration lockTTL) {
        this.lockService = lockService;
        this.scheduler = scheduler;
        this.lockTTL = lockTTL;
    }

    public void acquireAndKeepLock(String resource, int maxConcurrency) throws AlreadyLockedException {
        Optional<Lock> optionalLock = this.lockService.lock(resource, maxConcurrency);
        if (optionalLock.isEmpty()) {
            throw new AlreadyLockedException(StringUtils.f("Could not acquire lock for resource <%s> with max concurrency <%d>", resource, maxConcurrency));
        }
        this.scheduleLock(optionalLock.get());
    }

    public void acquireAndKeepLock(String resource, String lockContext) throws AlreadyLockedException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lockContext) ? 1 : 0) != 0, (Object)"lockContext cannot be blank");
        Optional<Lock> optionalLock = this.lockService.lock(resource, lockContext);
        if (optionalLock.isEmpty()) {
            throw new AlreadyLockedException(StringUtils.f("Could not acquire lock for resource <%s> and lock context <%s>", resource, lockContext));
        }
        this.scheduleLock(optionalLock.get());
    }

    private void scheduleLock(Lock newLock) {
        this.lock = newLock;
        Duration duration = this.lockTTL.minusSeconds(30L);
        if (duration.isNegative() || duration.isZero()) {
            duration = Duration.ofSeconds(1L);
        }
        this.lockRefreshFuture = this.scheduler.scheduleAtFixedRate(() -> this.refreshLock(this.lock), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void releaseLock() {
        if (this.lockRefreshFuture != null) {
            this.lockRefreshFuture.cancel(true);
            this.lockRefreshFuture = null;
        }
        if (this.lock != null) {
            this.lockService.unlock(this.lock);
            this.lock = null;
        }
    }

    private void refreshLock(Lock lock) {
        Optional<Lock> newLock = this.lockService.extendLock(lock);
        if (newLock.isEmpty()) {
            throw new RuntimeException("Failed to refresh lock. This should not happen!");
        }
    }

    @Override
    public void close() {
        this.releaseLock();
    }

    public static interface Factory {
        public RefreshingLockService create();
    }
}

