/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.cluster.nodes;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Map;
import java.util.Objects;
import org.bson.types.ObjectId;
import org.graylog2.cluster.nodes.AbstractNode;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.database.DbEntity;
import org.graylog2.datanode.DataNodeLifecycleTrigger;

@DbEntity(collection="datanodes", titleField="node_id")
public class DataNodeEntity
extends AbstractNode<DataNodeDto> {
    @JsonCreator
    public DataNodeEntity(Map<String, Object> fields) {
        super(fields);
    }

    public DataNodeEntity(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
    }

    public String getClusterAddress() {
        return (String)this.fields.get("cluster_address");
    }

    public String getRestApiAddress() {
        return (String)this.fields.get("rest_api_address");
    }

    public DataNodeLifecycleTrigger getActionQueue() {
        if (!this.fields.containsKey("action_queue") || Objects.isNull(this.fields.get("action_queue"))) {
            return null;
        }
        return DataNodeLifecycleTrigger.valueOf(this.fields.get("action_queue").toString());
    }

    public DataNodeStatus getDataNodeStatus() {
        if (!this.fields.containsKey("datanode_status")) {
            return null;
        }
        return DataNodeStatus.valueOf(this.fields.get("datanode_status").toString());
    }

    @Override
    public DataNodeDto toDto() {
        return ((DataNodeDto.Builder)((DataNodeDto.Builder)((DataNodeDto.Builder)((DataNodeDto.Builder)((DataNodeDto.Builder)((DataNodeDto.Builder)DataNodeDto.Builder.builder().setObjectId(this.getObjectId().toHexString())).setId(this.getNodeId())).setTransportAddress(this.getTransportAddress())).setLastSeen(this.getLastSeen())).setHostname(this.getHostname())).setLeader(this.isLeader())).setClusterAddress(this.getClusterAddress()).setDataNodeStatus(this.getDataNodeStatus()).setRestApiAddress(this.getRestApiAddress()).setActionQueue(this.getActionQueue()).build();
    }
}

