/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.validators;

import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Collectors;

public class RetentionStrategyValidator
implements Validator<Set<String>> {
    private static final String ARCHIVE_RETENTION_STRATEGY = "archive";
    Set<String> VALID_STRATEGIES = Sets.newHashSet((Object[])new String[]{"none", "close", "delete"});

    public void validate(String parameter, Set<String> values) throws ValidationException {
        if (!values.stream().filter(s -> !this.VALID_STRATEGIES.contains(s) && !ARCHIVE_RETENTION_STRATEGY.equals(s)).collect(Collectors.toSet()).isEmpty()) {
            throw new ValidationException("Parameter " + parameter + " contains invalid values: " + String.valueOf(values));
        }
        if (values.containsAll(this.VALID_STRATEGIES)) {
            throw new ValidationException(parameter + ":" + String.valueOf(values) + " At least one retention of the following [none, close, delete], should stay enabled!");
        }
    }
}

