/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration.validators;

import com.github.joschi.jadconfig.ValidationException;
import com.github.joschi.jadconfig.Validator;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class RotationStrategyValidator
implements Validator<List<String>> {
    Set<String> VALID_STRATEGIES = Sets.newHashSet((Object[])new String[]{"count", "size", "time", "time-size-optimizing"});

    public void validate(String parameter, List<String> value) throws ValidationException {
        if (value == null || value.isEmpty()) {
            throw new ValidationException("Parameter " + parameter + " should be non-empty list");
        }
        if (!value.stream().filter(s -> !this.VALID_STRATEGIES.contains(s)).collect(Collectors.toSet()).isEmpty()) {
            throw new ValidationException("Parameter " + parameter + " contains invalid values: " + String.valueOf(value));
        }
        if (value.stream().distinct().count() != (long)value.size()) {
            throw new ValidationException("Parameter " + parameter + " contains duplicate values: " + String.valueOf(value));
        }
    }
}

