/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentstream.rest;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.graylog2.contentstream.ContentStreamFeedTags;
import org.graylog2.contentstream.db.ContentStreamUserSettings;
import org.graylog2.contentstream.db.DBContentStreamUserSettingsService;
import org.graylog2.contentstream.rest.ContentStreamSettings;
import org.graylog2.plugin.database.users.User;
import org.graylog2.users.events.UserDeletedEvent;

public class ContentStreamService {
    private final DBContentStreamUserSettingsService dbContentStreamUserSettingsService;
    private final ContentStreamFeedTags contentStreamFeedTags;

    @Inject
    public ContentStreamService(DBContentStreamUserSettingsService dbContentStreamUserSettingsService, ContentStreamFeedTags contentStreamFeedTags, EventBus eventBus) {
        this.dbContentStreamUserSettingsService = dbContentStreamUserSettingsService;
        this.contentStreamFeedTags = contentStreamFeedTags;
        eventBus.register((Object)this);
    }

    public List<String> getTags() {
        return this.contentStreamFeedTags.getTags();
    }

    public ContentStreamSettings getUserSettings(User user) {
        Optional<ContentStreamUserSettings> dto = this.dbContentStreamUserSettingsService.findByUserId(user.getId());
        if (dto.isPresent()) {
            return ContentStreamSettings.builder().contentStreamEnabled(dto.get().contentStreamEnabled()).releasesEnabled(dto.get().releasesEnabled()).topics(dto.get().topics()).build();
        }
        return ContentStreamSettings.builder().contentStreamEnabled(true).releasesEnabled(true).topics(new ArrayList<String>()).build();
    }

    public void saveUserSettings(User user, ContentStreamSettings settings) {
        ContentStreamUserSettings.Builder builder = ContentStreamUserSettings.builder().userId(user.getId()).contentStreamEnabled(settings.contentStreamEnabled()).releasesEnabled(settings.releasesEnabled()).topics(settings.topics());
        this.dbContentStreamUserSettingsService.findByUserId(user.getId()).ifPresent(dto -> builder.id(dto.id()));
        this.dbContentStreamUserSettingsService.save(builder.build());
    }

    public void deleteUserSettingsByUser(User user) {
        this.deleteUserSettingsByUserId(user.getId());
    }

    @Subscribe
    private void handleUserDeletedEvent(UserDeletedEvent event) {
        this.deleteUserSettingsByUserId(event.userId());
    }

    private void deleteUserSettingsByUserId(String userId) {
        this.dbContentStreamUserSettingsService.delete(userId);
    }
}

