/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedList;
import org.mongojack.DBCursor;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;
import org.mongojack.JacksonDBCollection;
import org.mongojack.WriteResult;

public abstract class PaginatedDbService<DTO> {
    protected final JacksonDBCollection<DTO, ObjectId> db;

    protected PaginatedDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Class<DTO> dtoClass, String collectionName) {
        this.db = JacksonDBCollection.wrap(mongoConnection.getDatabase().getCollection(collectionName), dtoClass, ObjectId.class, mapper.get());
    }

    protected PaginatedDbService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, Class<DTO> dtoClass, String collectionName, @Nullable DBObject dbOptions) {
        DBCollection dbCollection = !mongoConnection.getDatabase().collectionExists(collectionName) ? mongoConnection.getDatabase().createCollection(collectionName, dbOptions) : mongoConnection.getDatabase().getCollection(collectionName);
        this.db = JacksonDBCollection.wrap(dbCollection, dtoClass, ObjectId.class, mapper.get());
    }

    public Optional<DTO> get(String id) {
        return Optional.ofNullable(this.db.findOneById(new ObjectId(id)));
    }

    public DTO save(DTO dto) {
        WriteResult<DTO, ObjectId> save = this.db.save(dto);
        return save.getSavedObject();
    }

    public int delete(String id) {
        return this.db.removeById(new ObjectId(id)).getN();
    }

    protected PaginatedList<DTO> findPaginatedWithQueryAndSort(Bson query, Bson sort, int page, int perPage) {
        try (DBCursor<DTO> cursor = this.db.find(query).sort(sort).limit(perPage).skip(perPage * Math.max(0, page - 1));){
            long grandTotal = this.db.count();
            PaginatedList<DTO> paginatedList = new PaginatedList<DTO>(this.asImmutableList(cursor), cursor.count(), page, perPage, grandTotal);
            return paginatedList;
        }
    }

    protected ImmutableList<DTO> asImmutableList(Iterator<? extends DTO> cursor) {
        return ImmutableList.copyOf(cursor);
    }

    protected PaginatedList<DTO> findPaginatedWithQueryFilterAndSort(Bson query, Predicate<DTO> filter, Bson sort, int page, int perPage) {
        return this.findPaginatedWithQueryFilterAndSortWithGrandTotal(query, filter, sort, (Bson)DBQuery.empty(), page, perPage);
    }

    protected PaginatedList<DTO> findPaginatedWithQueryFilterAndSortWithGrandTotal(Bson query, Predicate<DTO> filter, Bson sort, Bson grandTotalQuery, int page, int perPage) {
        long total;
        try (Stream<DTO> cursor = this.streamQueryWithSort(query, sort);){
            total = cursor.filter(filter).count();
        }
        try (Stream<DTO> resultStream = this.streamQueryWithSort(query, sort);){
            Stream<DTO> filteredResultStream = resultStream.filter(filter);
            if (perPage > 0) {
                filteredResultStream = filteredResultStream.skip(perPage * Math.max(0, page - 1)).limit(perPage);
            }
            long grandTotal = this.db.getCount(grandTotalQuery);
            PaginatedList paginatedList = new PaginatedList(filteredResultStream.collect(Collectors.toList()), Math.toIntExact(total), page, perPage, grandTotal);
            return paginatedList;
        }
    }

    public Stream<DTO> streamAll() {
        return this.streamQuery((Bson)DBQuery.empty());
    }

    public Stream<DTO> streamByIds(Set<String> idSet) {
        List objectIds = idSet.stream().map(ObjectId::new).collect(Collectors.toList());
        return this.streamQuery((Bson)DBQuery.in((String)"_id", objectIds));
    }

    protected Stream<DTO> streamQuery(Bson query) {
        DBCursor<DTO> cursor = this.db.find(query);
        return (Stream)Streams.stream(cursor).onClose(cursor::close);
    }

    protected Stream<DTO> streamQueryWithSort(Bson query, Bson sort) {
        DBCursor<DTO> cursor = this.db.find(query).sort(sort);
        return (Stream)Streams.stream(cursor).onClose(cursor::close);
    }

    @Deprecated
    protected DBSort.SortBuilder getSortBuilder(String order, String field) {
        DBSort.SortBuilder sortBuilder = "desc".equalsIgnoreCase(order) ? DBSort.desc((String)field) : DBSort.asc((String)field);
        return sortBuilder;
    }

    protected DBSort.SortBuilder getMultiFieldSortBuilder(String order, List<String> fields) {
        if (fields == null || fields.isEmpty()) {
            return DBSort.asc((String)"_id");
        }
        List distinctFields = fields.stream().distinct().toList();
        DBSort.SortBuilder sortBuilder = null;
        if ("desc".equalsIgnoreCase(order)) {
            for (String field : distinctFields) {
                if (sortBuilder == null) {
                    sortBuilder = DBSort.desc((String)field);
                    continue;
                }
                sortBuilder = sortBuilder.desc(field);
            }
        } else {
            for (String field : distinctFields) {
                if (sortBuilder == null) {
                    sortBuilder = DBSort.asc((String)field);
                    continue;
                }
                sortBuilder = sortBuilder.asc(field);
            }
        }
        return sortBuilder;
    }

    public static <T> List<T> getPage(List<T> sourceList, int page, int pageSize) {
        if (pageSize <= 0 || page <= 0) {
            throw new IllegalArgumentException("invalid page size: " + pageSize);
        }
        int fromIndex = (page - 1) * pageSize;
        if (sourceList == null || sourceList.size() <= fromIndex) {
            return Collections.emptyList();
        }
        return sourceList.subList(fromIndex, Math.min(fromIndex + pageSize, sourceList.size()));
    }
}

