/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.database.entities;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog2.database.entities.EntityScope;
import org.graylog2.database.entities.ScopedEntity;

public final class EntityScopeService {
    private final Map<String, EntityScope> entityScopes;

    @Inject
    public EntityScopeService(Set<EntityScope> entityScopes) {
        this.entityScopes = Objects.requireNonNull(entityScopes).stream().collect(Collectors.toMap(e -> e.getName().toUpperCase(Locale.ROOT), e -> e));
    }

    public List<EntityScope> getEntityScopes() {
        return Collections.unmodifiableList(new ArrayList<EntityScope>(this.entityScopes.values()));
    }

    public boolean isMutable(ScopedEntity scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        String scope = scopedEntity.scope();
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        EntityScope entityScope = this.entityScopes.get(scope.toUpperCase(Locale.ROOT));
        if (entityScope == null) {
            throw new IllegalArgumentException("Entity Scope does not exist: " + scope);
        }
        return entityScope.isMutable();
    }

    public boolean isMutable(ScopedEntity existingEntity, ScopedEntity updatedEntity) {
        Objects.requireNonNull(existingEntity, "Entity must not be null");
        String scope = existingEntity.scope();
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        EntityScope entityScope = this.entityScopes.get(scope.toUpperCase(Locale.ROOT));
        if (entityScope == null) {
            throw new IllegalArgumentException("Entity Scope does not exist: " + scope);
        }
        return entityScope.isMutable(existingEntity, updatedEntity);
    }

    public boolean isDeletable(ScopedEntity scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        String scope = scopedEntity.scope();
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        EntityScope entityScope = this.entityScopes.get(scope.toUpperCase(Locale.ROOT));
        if (entityScope == null) {
            throw new IllegalArgumentException("Entity Scope does not exist: " + scope);
        }
        return entityScope.isDeletable();
    }

    public boolean hasValidScope(ScopedEntity scopedEntity) {
        Objects.requireNonNull(scopedEntity, "Entity must not be null");
        String scope = scopedEntity.scope();
        return scope != null && this.entityScopes.containsKey(scope);
    }
}

