/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.krakens.grok.api.exception.GrokException;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.graylog2.database.NotFoundException;
import org.graylog2.events.ClusterEventBus;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.GrokPatternServiceImpl;
import org.graylog2.grok.GrokPatternsDeletedEvent;
import org.graylog2.grok.GrokPatternsUpdatedEvent;
import org.graylog2.plugin.database.ValidationException;

public class InMemoryGrokPatternService
extends GrokPatternServiceImpl {
    private final AtomicLong idGen = new AtomicLong(0L);
    private final ConcurrentMap<String, GrokPattern> store = new ConcurrentHashMap<String, GrokPattern>();
    private final ClusterEventBus clusterBus;

    @Inject
    public InMemoryGrokPatternService(ClusterEventBus clusterBus) {
        this.clusterBus = clusterBus;
    }

    @Override
    public GrokPattern load(String patternId) throws NotFoundException {
        GrokPattern pattern = (GrokPattern)this.store.get(patternId);
        if (pattern == null) {
            throw new NotFoundException("Couldn't find Grok pattern with ID " + patternId);
        }
        return pattern;
    }

    @Override
    public Optional<GrokPattern> loadByName(String name) {
        return this.store.values().stream().filter(pattern -> pattern.name().equals(name)).findAny();
    }

    @Override
    public Set<GrokPattern> bulkLoad(Collection<String> patternIds) {
        return patternIds.stream().map(this.store::get).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public Set<GrokPattern> loadAll() {
        return Sets.newHashSet(this.store.values());
    }

    @Override
    public GrokPattern update(GrokPattern pattern) throws ValidationException {
        return this.save(pattern);
    }

    @Override
    public GrokPattern save(GrokPattern pattern) throws ValidationException {
        try {
            if (!this.validate(pattern)) {
                throw new ValidationException("Pattern " + pattern.name() + " invalid.");
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid pattern " + String.valueOf(pattern) + "\n" + e.getMessage());
        }
        GrokPattern toSave = pattern.id() == null ? pattern.toBuilder().id(this.createId()).build() : pattern;
        this.store.put(toSave.id(), toSave);
        this.clusterBus.post(GrokPatternsUpdatedEvent.create((Set<String>)ImmutableSet.of((Object)toSave.name())));
        return toSave;
    }

    private GrokPattern uncheckedSave(GrokPattern pattern) {
        try {
            return this.save(pattern);
        }
        catch (ValidationException e) {
            return null;
        }
    }

    @Override
    public List<GrokPattern> saveAll(Collection<GrokPattern> patterns, GrokPatternService.ImportStrategy importStrategy) throws ValidationException {
        if (importStrategy == GrokPatternService.ImportStrategy.ABORT_ON_CONFLICT) {
            for (GrokPattern pattern : this.loadAll()) {
                boolean patternExists = patterns.stream().anyMatch(p -> p.name().equals(pattern.name()));
                if (!patternExists) continue;
                throw new ValidationException("Grok pattern " + pattern.name() + " already exists");
            }
        }
        this.validateAllOrThrow(patterns, importStrategy);
        List<GrokPattern> grokPatterns = patterns.stream().map(this::uncheckedSave).collect(Collectors.toList());
        Set<String> patternNames = grokPatterns.stream().map(GrokPattern::name).collect(Collectors.toSet());
        if (!patternNames.isEmpty()) {
            this.clusterBus.post(GrokPatternsUpdatedEvent.create(patternNames));
        }
        return grokPatterns;
    }

    @Override
    public int delete(String patternId) {
        GrokPattern grokPattern = (GrokPattern)this.store.remove(patternId);
        if (grokPattern != null) {
            this.clusterBus.post(GrokPatternsDeletedEvent.create((Set<String>)ImmutableSet.of((Object)grokPattern.name())));
        }
        return grokPattern == null ? 0 : 1;
    }

    @Override
    public int deleteAll() {
        Set<String> patternNames = this.store.values().stream().map(GrokPattern::name).collect(Collectors.toSet());
        if (!patternNames.isEmpty()) {
            this.store.clear();
            this.clusterBus.post(GrokPatternsDeletedEvent.create(patternNames));
        }
        return patternNames.size();
    }

    private String createId() {
        return String.valueOf(this.idGen.incrementAndGet());
    }
}

