/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog2.indexer.NoTargetIndexException;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.indexer.indices.TooManyAliasesException;

public interface IndexSet
extends Comparable<IndexSet> {
    public String[] getManagedIndices();

    public String getWriteIndexAlias();

    public String getIndexWildcard();

    public String getNewestIndex() throws NoTargetIndexException;

    @Nullable
    public String getActiveWriteIndex() throws TooManyAliasesException;

    public Map<String, Set<String>> getAllIndexAliases();

    public String getIndexPrefix();

    public boolean isUp();

    public boolean isWriteIndexAlias(String var1);

    public boolean isManagedIndex(String var1);

    public void setUp();

    public void cycle();

    public void cleanupAliases(Set<String> var1);

    public void pointTo(String var1, String var2);

    public Optional<Integer> extractIndexNumber(String var1);

    default public Comparator<String> indexComparator() {
        return (indexName1, indexName2) -> this.extractIndexNumber((String)indexName2).orElse(0).compareTo(this.extractIndexNumber((String)indexName1).orElse(0));
    }

    public IndexSetConfig getConfig();

    default public String getNthIndexBeforeActiveIndexSet(int n) {
        String activeWriteIndex = this.getActiveWriteIndex();
        if (activeWriteIndex != null) {
            Optional<Integer> deflectorNumber = this.extractIndexNumber(activeWriteIndex);
            String indexPrefix = this.getIndexPrefix();
            return deflectorNumber.map(num -> {
                int indexNumber = num - n;
                if (indexNumber >= 0) {
                    return indexPrefix + "_" + indexNumber;
                }
                return null;
            }).orElse(null);
        }
        return null;
    }

    public static class IndexNameComparator
    implements Comparator<String> {
        private final IndexSet indexSet;

        IndexNameComparator(IndexSet indexSet) {
            this.indexSet = Objects.requireNonNull(indexSet);
        }

        @Override
        public int compare(String o1, String o2) {
            int indexNumber1 = this.indexSet.extractIndexNumber(o1).orElse(-1);
            int indexNumber2 = this.indexSet.extractIndexNumber(o2).orElse(-1);
            return ComparisonChain.start().compare(indexNumber1, indexNumber2).result();
        }
    }
}

