/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indexset;

import jakarta.inject.Inject;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfigurationFactory;
import org.graylog2.datatiering.DataTieringChecker;
import org.graylog2.datatiering.DataTieringConfig;
import org.graylog2.indexer.indexset.IndexSetConfig;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexSetConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(IndexSetConfigFactory.class);
    private final IndexSetsDefaultConfigurationFactory indexSetsDefaultConfigurationFactory;
    private final ClusterConfigService clusterConfigService;
    private final DataTieringChecker dataTieringChecker;

    @Inject
    public IndexSetConfigFactory(IndexSetsDefaultConfigurationFactory indexSetsDefaultConfigurationFactory, ClusterConfigService clusterConfigService, DataTieringChecker dataTieringChecker) {
        this.indexSetsDefaultConfigurationFactory = indexSetsDefaultConfigurationFactory;
        this.clusterConfigService = clusterConfigService;
        this.dataTieringChecker = dataTieringChecker;
    }

    private static ZonedDateTime getCreationDate() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    private static DataTieringConfig getDataTieringConfig(IndexSetsDefaultConfiguration defaultConfig) {
        return defaultConfig.useLegacyRotation() != false ? null : defaultConfig.dataTiering();
    }

    public IndexSetConfig.Builder createDefault() {
        IndexSetsDefaultConfiguration defaultConfig = this.clusterConfigService.get(IndexSetsDefaultConfiguration.class);
        if (defaultConfig == null) {
            LOG.debug("Could not find IndexSetsDefaultConfiguration. Falling back to server configuration values.");
            defaultConfig = this.indexSetsDefaultConfigurationFactory.create();
        }
        return IndexSetConfig.builder().creationDate(IndexSetConfigFactory.getCreationDate()).indexAnalyzer(defaultConfig.indexAnalyzer()).shards(defaultConfig.shards()).replicas(defaultConfig.replicas()).indexOptimizationDisabled(defaultConfig.indexOptimizationDisabled()).indexOptimizationMaxNumSegments(defaultConfig.indexOptimizationMaxNumSegments()).fieldTypeRefreshInterval(Duration.standardSeconds((long)defaultConfig.fieldTypeRefreshIntervalUnit().toSeconds(defaultConfig.fieldTypeRefreshInterval()))).rotationStrategyClass(defaultConfig.rotationStrategyClass()).rotationStrategy(defaultConfig.rotationStrategyConfig()).retentionStrategyClass(defaultConfig.retentionStrategyClass()).retentionStrategy(defaultConfig.retentionStrategyConfig()).dataTiering(this.dataTieringChecker.isEnabled() ? IndexSetConfigFactory.getDataTieringConfig(defaultConfig) : null);
    }
}

