/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import java.util.Optional;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePoller;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.indices.jobs.OptimizeIndexJob;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.plugin.Tools;
import org.graylog2.shared.system.activities.Activity;
import org.graylog2.shared.system.activities.ActivityWriter;
import org.graylog2.system.jobs.SystemJob;
import org.graylog2.system.jobs.SystemJobConcurrencyException;
import org.graylog2.system.jobs.SystemJobManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetIndexReadOnlyAndCalculateRangeJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(SetIndexReadOnlyAndCalculateRangeJob.class);
    private final OptimizeIndexJob.Factory optimizeIndexJobFactory;
    private final CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory;
    private final IndexSetRegistry indexSetRegistry;
    private final Indices indices;
    private final IndexFieldTypesService indexFieldTypesService;
    private final IndexFieldTypePoller indexFieldTypePoller;
    private final ActivityWriter activityWriter;
    private final SystemJobManager systemJobManager;
    private final String indexName;

    @Inject
    public SetIndexReadOnlyAndCalculateRangeJob(OptimizeIndexJob.Factory optimizeIndexJobFactory, CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory, IndexSetRegistry indexSetRegistry, Indices indices, IndexFieldTypesService indexFieldTypesService, IndexFieldTypePoller indexFieldTypePoller, ActivityWriter activityWriter, SystemJobManager systemJobManager, @Assisted String indexName) {
        this.optimizeIndexJobFactory = optimizeIndexJobFactory;
        this.createNewSingleIndexRangeJobFactory = createNewSingleIndexRangeJobFactory;
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
        this.indexFieldTypesService = indexFieldTypesService;
        this.indexFieldTypePoller = indexFieldTypePoller;
        this.activityWriter = activityWriter;
        this.systemJobManager = systemJobManager;
        this.indexName = indexName;
    }

    @Override
    public void execute() {
        if (!this.indices.exists(this.indexName)) {
            LOG.debug("Not running job for deleted index <{}>", (Object)this.indexName);
            return;
        }
        if (this.indices.isClosed(this.indexName)) {
            LOG.debug("Not running job for closed index <{}>", (Object)this.indexName);
            return;
        }
        this.setReadonly();
        CreateNewSingleIndexRangeJob createNewSingleIndexRangeJob = this.createNewSingleIndexRangeJobFactory.create(this.indexSetRegistry.getAll(), this.indexName);
        ((SystemJob)createNewSingleIndexRangeJob).execute();
        this.indexSetRegistry.getForIndex(this.indexName).ifPresent(indexSet -> this.indexFieldTypePoller.pollIndex(this.indexName, indexSet.getConfig().id()).ifPresent(this.indexFieldTypesService::upsert));
    }

    public String getIndex() {
        return this.indexName;
    }

    public void setReadonly() {
        Optional<IndexSet> indexSet = this.indexSetRegistry.getForIndex(this.indexName);
        if (indexSet.isEmpty()) {
            LOG.error("Couldn't find index set for index <{}>", (Object)this.indexName);
            return;
        }
        LOG.info("Flushing old index <{}>.", (Object)this.indexName);
        this.indices.flush(this.indexName);
        this.indices.setClosingDate(this.indexName, Tools.nowUTC());
        LOG.info("Setting old index <{}> to read-only.", (Object)this.indexName);
        this.indices.setReadOnly(this.indexName);
        this.activityWriter.write(new Activity("Flushed and set <" + this.indexName + "> to read-only.", SetIndexReadOnlyAndCalculateRangeJob.class));
        if (!indexSet.get().getConfig().indexOptimizationDisabled()) {
            try {
                this.systemJobManager.submit(this.optimizeIndexJobFactory.create(this.indexName, indexSet.get().getConfig().indexOptimizationMaxNumSegments()));
            }
            catch (SystemJobConcurrencyException e) {
                LOG.error("Cannot optimize index <" + this.indexName + ">.", (Throwable)e);
            }
        }
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Makes index " + this.indexName + " read only and calculates and adds its index range afterwards.";
    }

    @Override
    public String getInfo() {
        return "Make index <%s> read only and calculate ranges".formatted(this.indexName);
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public SetIndexReadOnlyAndCalculateRangeJob create(String var1);
    }
}

