/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.results;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.codec.digest.DigestUtils;
import org.graylog2.indexer.results.ChunkedResult;
import org.graylog2.indexer.results.IndexQueryResult;
import org.graylog2.indexer.results.ResultChunk;
import org.graylog2.indexer.results.ResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChunkedQueryResult<C, R>
extends IndexQueryResult
implements ChunkedResult {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkedQueryResult.class);
    protected final C client;
    protected R initialResult;
    protected R lastSearchResponse;
    private final List<String> fields;
    private final long totalHits;
    private final String queryHash;
    private final int limit;
    private int chunkId = 0;
    private int resultCount = 0;
    private final long tookMs;

    public ChunkedQueryResult(C client, R initialResult, String query, List<String> fields, int limit) {
        super(query, null);
        this.tookMs = this.getTookMillisFromResponse(initialResult);
        this.client = client;
        this.totalHits = this.countTotalHits(initialResult);
        this.limit = limit;
        this.initialResult = initialResult;
        this.fields = fields;
        this.queryHash = DigestUtils.md5Hex((String)this.getOriginalQuery());
        LOG.debug("[{}] Starting {} request for query {}", new Object[]{this.queryHash, this.getChunkingMethodName(), this.getOriginalQuery()});
    }

    @Override
    @Nullable
    public ResultChunk nextChunk() throws IOException {
        List<ResultMessage> resultMessages;
        if (this.limitReached()) {
            LOG.debug("[{}] Reached limit for query {}", (Object)this.queryHash, (Object)this.getOriginalQuery());
            return null;
        }
        R result = this.initialResult != null ? this.initialResult : this.nextSearchResult();
        this.lastSearchResponse = result;
        this.initialResult = null;
        List<ResultMessage> list = resultMessages = result != null ? this.collectMessagesFromResult(result) : List.of();
        if (resultMessages.isEmpty()) {
            LOG.debug("[{}] Reached end of {} results for query {}", new Object[]{this.queryHash, this.getChunkingMethodName(), this.getOriginalQuery()});
            return null;
        }
        int remainingResultsForLimit = this.limit - this.resultCount;
        List<ResultMessage> resultMessagesSlice = this.limit != -1 && remainingResultsForLimit < resultMessages.size() ? resultMessages.subList(0, remainingResultsForLimit) : resultMessages;
        this.resultCount += resultMessagesSlice.size();
        return new ResultChunk(this.fields, this.chunkId++, resultMessagesSlice);
    }

    protected abstract List<ResultMessage> collectMessagesFromResult(R var1);

    @Nullable
    protected abstract R nextSearchResult() throws IOException;

    protected abstract String getChunkingMethodName();

    protected abstract long countTotalHits(R var1);

    protected abstract long getTookMillisFromResponse(R var1);

    @Override
    public long tookMs() {
        return this.tookMs;
    }

    private boolean limitReached() {
        return this.limit != -1 && this.resultCount >= this.limit;
    }

    @Override
    public String getQueryHash() {
        return this.queryHash;
    }

    @Override
    public long totalHits() {
        return this.totalHits;
    }
}

