/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.retention.strategies;

import java.util.List;
import java.util.Optional;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.retention.executors.CountBasedRetentionExecutor;
import org.graylog2.indexer.retention.executors.TimeBasedRetentionExecutor;
import org.graylog2.indexer.rotation.strategies.TimeBasedSizeOptimizingStrategyConfig;
import org.graylog2.indexer.rotation.tso.IndexLifetimeConfig;
import org.graylog2.plugin.indexer.retention.RetentionStrategy;
import org.graylog2.plugin.indexer.rotation.RotationStrategyConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIndexRetentionStrategy
implements RetentionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractIndexRetentionStrategy.class);
    private final CountBasedRetentionExecutor countBasedRetentionExecutor;
    private final TimeBasedRetentionExecutor timeBasedRetentionExecutor;

    protected AbstractIndexRetentionStrategy(CountBasedRetentionExecutor countBasedRetentionExecutor, TimeBasedRetentionExecutor timeBasedRetentionExecutor) {
        this.countBasedRetentionExecutor = countBasedRetentionExecutor;
        this.timeBasedRetentionExecutor = timeBasedRetentionExecutor;
    }

    protected abstract Optional<Integer> getMaxNumberOfIndices(IndexSet var1);

    protected abstract void retain(List<String> var1, IndexSet var2);

    @Override
    public void retain(IndexSet indexSet) {
        RotationStrategyConfig rotationStrategyConfig = indexSet.getConfig().rotationStrategy();
        if (rotationStrategyConfig instanceof TimeBasedSizeOptimizingStrategyConfig) {
            TimeBasedSizeOptimizingStrategyConfig timeBasedConfig = (TimeBasedSizeOptimizingStrategyConfig)rotationStrategyConfig;
            this.retainTimeBased(indexSet, timeBasedConfig);
        } else {
            this.retainCountBased(indexSet);
        }
    }

    private void retainTimeBased(IndexSet indexSet, TimeBasedSizeOptimizingStrategyConfig timeBasedConfig) {
        this.timeBasedRetentionExecutor.retain(indexSet, IndexLifetimeConfig.builder().indexLifetimeMax(timeBasedConfig.indexLifetimeMax()).indexLifetimeMin(timeBasedConfig.indexLifetimeMin()).build(), this::retain, this.getClass().getCanonicalName());
    }

    private void retainCountBased(IndexSet indexSet) {
        this.countBasedRetentionExecutor.retain(indexSet, this.getMaxNumberOfIndices(indexSet).orElse(null), this::retain, this.getClass().getCanonicalName());
    }
}

