/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.transports.netty;

import com.codahale.metrics.MetricRegistry;
import io.netty.channel.EventLoopGroup;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import org.graylog2.inputs.transports.NettyTransportConfiguration;
import org.graylog2.inputs.transports.netty.EventLoopGroupFactory;

public class EventLoopGroupProvider
implements Provider<EventLoopGroup> {
    private final EventLoopGroupFactory eventLoopGroupFactory;
    private final NettyTransportConfiguration configuration;
    private final MetricRegistry metricRegistry;

    @Inject
    public EventLoopGroupProvider(EventLoopGroupFactory eventLoopGroupFactory, NettyTransportConfiguration configuration, MetricRegistry metricRegistry) {
        this.eventLoopGroupFactory = eventLoopGroupFactory;
        this.configuration = configuration;
        this.metricRegistry = metricRegistry;
    }

    public EventLoopGroup get() {
        String name = "netty-transport";
        int numThreads = this.configuration.getNumThreads();
        return this.eventLoopGroupFactory.create(numThreads, this.metricRegistry, "netty-transport");
    }
}

