/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.lookup.adapters;

import au.com.bytecode.opencsv.CSVReader;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.graylog2.lookup.AllowedAuxiliaryPathChecker;
import org.graylog2.lookup.adapters.$AutoValue_CSVFileDataAdapter_Config;
import org.graylog2.lookup.adapters.LookupDataAdapterValidationContext;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.plugin.utilities.FileInfo;
import org.graylog2.shared.utilities.StringUtils;
import org.graylog2.utilities.CIDRPatriciaTrie;
import org.graylog2.utilities.IpSubnet;
import org.graylog2.utilities.ReservedIpChecker;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVFileDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(CSVFileDataAdapter.class);
    public static final String NAME = "csvfile";
    public static final String ALLOWED_PATH_ERROR = "The specified CSV file either does not exist or is not in an allowed path.";
    private final Config config;
    private final AllowedAuxiliaryPathChecker pathChecker;
    private final AtomicReference<Map<String, String>> lookupRef = new AtomicReference<ImmutableMap>(ImmutableMap.of());
    private final AtomicReference<CIDRPatriciaTrie> cidrLookupRef = new AtomicReference<CIDRPatriciaTrie>(new CIDRPatriciaTrie());
    private final String name;
    private FileInfo fileInfo = FileInfo.empty();

    @Inject
    public CSVFileDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, AllowedAuxiliaryPathChecker pathChecker) {
        super(id, name, config, metricRegistry);
        this.name = name;
        this.config = (Config)config;
        this.pathChecker = pathChecker;
    }

    @Override
    public void doStart() throws Exception {
        LOG.debug("Starting CSV data adapter for file: {}", (Object)this.config.path());
        if (Strings.isNullOrEmpty((String)this.config.path())) {
            throw new IllegalStateException("File path needs to be set");
        }
        if (!this.pathChecker.fileIsInAllowedPath(Paths.get(this.config.path(), new String[0]))) {
            throw new IllegalStateException(ALLOWED_PATH_ERROR);
        }
        if (this.config.checkInterval() < 1L) {
            throw new IllegalStateException("Check interval setting cannot be smaller than 1");
        }
        this.fileInfo = this.getNewFileInfo();
        this.setLookupRefFromCSV();
    }

    @Override
    public Duration refreshInterval() {
        return Duration.standardSeconds((long)Ints.saturatedCast((long)this.config.checkInterval()));
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        if (!this.pathChecker.fileIsInAllowedPath(Paths.get(this.config.path(), new String[0]))) {
            LOG.error(ALLOWED_PATH_ERROR);
            this.setError(new IllegalStateException(ALLOWED_PATH_ERROR));
            return;
        }
        if (!Files.isReadable(Paths.get(this.config.path(), new String[0]))) {
            String error = StringUtils.f("The specified file [%s] does not exist or is not readable. To resolve this error, edit the adapter [%s] and specify a new path, or restore the file or read access to it.", this.config.path(), this.name);
            LOG.error(error);
            this.setError(new IllegalStateException(error));
            return;
        }
        try {
            FileInfo.Change fileChanged = this.fileInfo.checkForChange();
            if (!fileChanged.isChanged() && !this.getError().isPresent()) {
                return;
            }
            LOG.debug("CSV file {} has changed, updating data", (Object)this.config.path());
            this.setLookupRefFromCSV();
            cachePurge.purgeAll();
            this.fileInfo = fileChanged.fileInfo() != null ? fileChanged.fileInfo() : this.getNewFileInfo();
            this.clearError();
        }
        catch (IOException e) {
            LOG.error("Couldn't check data adapter <{}> CSV file {} for updates: {} {}", new Object[]{this.name(), this.config.path(), e.getClass().getCanonicalName(), e.getMessage()});
            this.setError(e);
        }
    }

    private void setLookupRefFromCSV() throws IOException {
        InputStream inputStream = Files.newInputStream(Paths.get(this.config.path(), new String[0]), new OpenOption[0]);
        InputStreamReader fileReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        ImmutableMap.Builder newLookupBuilder = ImmutableMap.builder();
        CIDRPatriciaTrie cidrLookupTrie = new CIDRPatriciaTrie();
        try (CSVReader csvReader = new CSVReader((Reader)fileReader, this.config.separatorAsChar(), this.config.quotecharAsChar());){
            String[] next;
            int line = 0;
            int keyColumn = -1;
            int valueColumn = -1;
            block9: while ((next = csvReader.readNext()) != null) {
                String value;
                String key;
                if (++line == 1) {
                    int col = 0;
                    String[] stringArray = next;
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block9;
                        String column = stringArray[n2];
                        if (!Strings.isNullOrEmpty((String)column)) {
                            if (this.config.keyColumn().equals(column)) {
                                keyColumn = col;
                            }
                            if (this.config.valueColumn().equals(column)) {
                                valueColumn = col;
                            }
                        }
                        ++col;
                        ++n2;
                    }
                }
                if (keyColumn < 0 || valueColumn < 0) {
                    throw new IllegalStateException("Couldn't detect column number for key or value - check CSV file format");
                }
                if (next.length == 1 && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)next[0])) {
                    LOG.debug("Skipping empty line in CSV adapter file [{}/{}].", (Object)this.name, (Object)this.config.path());
                    continue;
                }
                try {
                    key = next[keyColumn];
                    value = next[valueColumn];
                }
                catch (IndexOutOfBoundsException e) {
                    String error = StringUtils.f("The CSV file [%s] contains invalid lines. Please check the file and ensure that both key and value columns are present in all lines.", this.name);
                    throw new IllegalStateException(error, e);
                }
                if (!this.config.isCidrLookup()) {
                    if (this.config.isCaseInsensitiveLookup()) {
                        newLookupBuilder.put((Object)key.toLowerCase(Locale.ENGLISH), (Object)value);
                        continue;
                    }
                    newLookupBuilder.put((Object)key, (Object)value);
                    continue;
                }
                Optional<IpSubnet> optSubnet = ReservedIpChecker.stringToSubnet(key);
                if (optSubnet.isPresent()) {
                    cidrLookupTrie.insertCIDR(key, value);
                    continue;
                }
                String cidr = this.ipAddressToCIDR(key);
                if (cidr == null) continue;
                cidrLookupTrie.insertCIDR(cidr, value);
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't parse CSV file {} (settings separator=<{}> quotechar=<{}> key_column=<{}> value_column=<{}>)", new Object[]{this.config.path(), this.config.separator(), this.config.quotechar(), this.config.keyColumn(), this.config.valueColumn(), e});
            this.setError(e);
            throw new IllegalStateException(e);
        }
        if (this.config.isCidrLookup()) {
            this.cidrLookupRef.set(cidrLookupTrie);
        } else {
            this.lookupRef.set((Map<String, String>)newLookupBuilder.build());
        }
    }

    private String ipAddressToCIDR(String ip) {
        String cidr = null;
        try {
            InetAddress address = InetAddresses.forString((String)ip);
            if (address instanceof Inet4Address) {
                cidr = StringUtils.f("%s/32", ip);
            } else if (address instanceof Inet6Address) {
                cidr = StringUtils.f("%s/128", ip);
            }
        }
        catch (IllegalArgumentException ignored) {
            LOG.warn("Key <{}> in CIDR lookup CSV data adapter <{}> is not a valid CIDR or IP address. Skipping invalid line.", (Object)ip, (Object)this.name);
        }
        return cidr;
    }

    private FileInfo getNewFileInfo() {
        return FileInfo.forPath(Paths.get(this.config.path(), new String[0]));
    }

    @Override
    public void doStop() throws Exception {
        LOG.debug("Stopping CSV data adapter for file: {}", (Object)this.config.path());
    }

    @Override
    public LookupResult doGet(Object key) {
        if (this.config.isCidrLookup()) {
            return this.getResultForCIDRRange(key);
        }
        String stringKey = this.config.isCaseInsensitiveLookup() ? String.valueOf(key).toLowerCase(Locale.ENGLISH) : String.valueOf(key);
        String value = this.lookupRef.get().get(stringKey);
        if (value == null) {
            return this.getEmptyResult();
        }
        return LookupResult.single(value);
    }

    public LookupResult getResultForCIDRRange(Object ip) {
        LookupResult result = this.getEmptyResult();
        try {
            String resultValue = this.cidrLookupRef.get().longestPrefixRangeLookup(String.valueOf(ip));
            if (resultValue != null) {
                result = LookupResult.single(resultValue);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.debug("Attempted to do a CIDR range lookup on invalid IP '{}'", ip);
            return this.getErrorResult();
        }
        return result;
    }

    @Override
    public void set(Object key, Object value) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_CSVFileDataAdapter_Config.Builder.class)
    @JsonTypeName(value="csvfile")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="path")
        @NotEmpty
        public abstract String path();

        @JsonProperty(value="separator")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract @Size(min=1, max=1) @NotEmpty String separator();

        @JsonIgnore
        public char separatorAsChar() {
            return this.separator().charAt(0);
        }

        @JsonProperty(value="quotechar")
        @Size(min=1, max=1)
        @NotEmpty
        public abstract @Size(min=1, max=1) @NotEmpty String quotechar();

        @JsonIgnore
        public char quotecharAsChar() {
            return this.quotechar().charAt(0);
        }

        @JsonProperty(value="key_column")
        @NotEmpty
        public abstract String keyColumn();

        @JsonProperty(value="value_column")
        @NotEmpty
        public abstract String valueColumn();

        @JsonProperty(value="check_interval")
        @Min(value=1L)
        public abstract @Min(value=1L) long checkInterval();

        @JsonProperty(value="case_insensitive_lookup")
        public abstract Optional<Boolean> caseInsensitiveLookup();

        @JsonProperty(value="cidr_lookup")
        public abstract Optional<Boolean> cidrLookup();

        public boolean isCaseInsensitiveLookup() {
            return this.caseInsensitiveLookup().isPresent() && this.caseInsensitiveLookup().get() != false;
        }

        public boolean isCidrLookup() {
            return this.cidrLookup().isPresent() && this.cidrLookup().get() != false;
        }

        public static Builder builder() {
            return new $AutoValue_CSVFileDataAdapter_Config.Builder();
        }

        @Override
        public Optional<Multimap<String, String>> validate(LookupDataAdapterValidationContext context) {
            ArrayListMultimap errors = ArrayListMultimap.create();
            Path path = Paths.get(this.path(), new String[0]);
            if (!context.getPathChecker().fileIsInAllowedPath(path)) {
                errors.put((Object)"path", (Object)CSVFileDataAdapter.ALLOWED_PATH_ERROR);
                return Optional.of(errors);
            }
            if (!Files.exists(path, new LinkOption[0])) {
                errors.put((Object)"path", (Object)"The file does not exist.");
            } else if (!Files.isReadable(path)) {
                errors.put((Object)"path", (Object)"The file cannot be read.");
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @Override
        public boolean isCloudCompatible() {
            return false;
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="path")
            public abstract Builder path(String var1);

            @JsonProperty(value="separator")
            public abstract Builder separator(String var1);

            @JsonProperty(value="quotechar")
            public abstract Builder quotechar(String var1);

            @JsonProperty(value="key_column")
            public abstract Builder keyColumn(String var1);

            @JsonProperty(value="value_column")
            public abstract Builder valueColumn(String var1);

            @JsonProperty(value="check_interval")
            public abstract Builder checkInterval(long var1);

            @JsonProperty(value="case_insensitive_lookup")
            public abstract Builder caseInsensitiveLookup(Boolean var1);

            @JsonProperty(value="cidr_lookup")
            public abstract Builder cidrLookup(Boolean var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(CSVFileDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(CSVFileDataAdapter.NAME).path("/etc/graylog/lookup-table.csv").separator(",").quotechar("\"").keyColumn("key").valueColumn("value").checkInterval(60L).caseInsensitiveLookup(false).cidrLookup(false).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<CSVFileDataAdapter> {
        @Override
        public CSVFileDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

