/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.bson.conversions.Bson;
import org.graylog.plugins.map.config.DatabaseVendorType;
import org.graylog.plugins.map.config.GeoIpResolverConfig;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.AutoValue_V20211221144300_GeoIpResolverConfigMigration_MigrationCompletion;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20211221144300_GeoIpResolverConfigMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20211221144300_GeoIpResolverConfigMigration.class);
    private static final String COLLECTION_NAME = "cluster_config";
    public static final String PAYLOAD = "payload";
    private static final String FIELD_DB_VENDOR = "payload.db_vendor_type";
    private static final String FIELD_DB_TYPE = "payload.db_type";
    private static final String FIELD_DB_PATH = "payload.db_path";
    private static final String FIELD_CITY_DB_PATH = "payload.city_db_path";
    private static final String FIELD_ASN_DB_PATH = "payload.asn_db_path";
    private static final String FIELD_ENFORCE = "payload.enforce_graylog_schema";
    private final MongoConnection mongoConnection;
    private final ClusterConfigService clusterConfigService;

    @Inject
    public V20211221144300_GeoIpResolverConfigMigration(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.mongoConnection = mongoConnection;
        this.clusterConfigService = clusterConfigService;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-01-28t16:38Z");
    }

    @Override
    public void upgrade() {
        MigrationCompletion completion = this.clusterConfigService.get(MigrationCompletion.class);
        if (completion != null) {
            LOG.debug("Migration was already completed");
            return;
        }
        MongoCollection collection = this.mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
        LOG.info("Updating '{}' collection.", (Object)COLLECTION_NAME);
        Bson geoConfFilter = Filters.eq((String)"type", (Object)GeoIpResolverConfig.class.getCanonicalName());
        Bson noColumnFilter = Filters.exists((String)FIELD_DB_VENDOR, (boolean)false);
        Bson setEnforceSchema = Updates.set((String)FIELD_ENFORCE, (Object)false);
        Bson setAsnPath = Updates.set((String)FIELD_ASN_DB_PATH, (Object)"");
        Bson renameDbTypeToVendor = Updates.rename((String)FIELD_DB_TYPE, (String)FIELD_DB_VENDOR);
        Bson renameDbPath = Updates.rename((String)FIELD_DB_PATH, (String)FIELD_CITY_DB_PATH);
        Bson updates = Updates.combine((Bson[])new Bson[]{setEnforceSchema, renameDbTypeToVendor, renameDbPath, setAsnPath});
        LOG.info("Planned Updates: {}", (Object)updates);
        UpdateResult updateResult = collection.updateOne(Filters.and((Bson[])new Bson[]{geoConfFilter, noColumnFilter}), updates);
        LOG.info("Update Result: {}", (Object)updateResult);
        Bson setDefaultVendor = Updates.set((String)FIELD_DB_VENDOR, (Object)DatabaseVendorType.MAXMIND.name());
        LOG.info("Setting default vendor: {}", (Object)setDefaultVendor);
        UpdateResult updateVendorResult = collection.updateOne(geoConfFilter, setDefaultVendor);
        LOG.info("Default Vendor Update Result: {}", (Object)updateVendorResult);
        this.clusterConfigService.write(MigrationCompletion.create());
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompletion {
        @JsonCreator
        public static MigrationCompletion create() {
            return new AutoValue_V20211221144300_GeoIpResolverConfigMigration_MigrationCompletion();
        }
    }
}

