/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.outputs;

import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.graylog2.outputs.DefaultMessageOutput;
import org.graylog2.outputs.OutputRegistry;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.outputs.MessageOutput;
import org.graylog2.plugin.streams.Output;
import org.graylog2.plugin.streams.Stream;

public class OutputRouter {
    private final MessageOutput defaultMessageOutput;
    private final OutputRegistry outputRegistry;

    @Inject
    public OutputRouter(@DefaultMessageOutput MessageOutput defaultMessageOutput, OutputRegistry outputRegistry) {
        this.defaultMessageOutput = defaultMessageOutput;
        this.outputRegistry = outputRegistry;
    }

    protected Set<MessageOutput> getMessageOutputsForStream(Stream stream) {
        HashSet<MessageOutput> result = new HashSet<MessageOutput>();
        for (Output output : stream.getOutputs()) {
            MessageOutput messageOutput = this.outputRegistry.getOutputForIdAndStream(output.getId(), stream);
            if (messageOutput == null) continue;
            result.add(messageOutput);
        }
        return result;
    }

    public Set<MessageOutput> getOutputsForMessage(Message msg) {
        Set<MessageOutput> result = this.getStreamOutputsForMessage(msg);
        result.add(this.defaultMessageOutput);
        return result;
    }

    public Set<MessageOutput> getStreamOutputsForMessage(Message msg) {
        HashSet<MessageOutput> result = new HashSet<MessageOutput>();
        for (Stream stream : msg.getStreams()) {
            result.addAll(this.getMessageOutputsForStream(stream));
        }
        return result;
    }
}

