/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.graylog2.plugin.rest.ApiError;
import org.graylog2.plugin.rest.GenericError;
import org.graylog2.plugin.rest.ValidationApiError;
import org.graylog2.rest.MoreMediaTypes;

@Provider
@Produces(value={"text/csv"})
public class GenericErrorCsvWriter
implements MessageBodyWriter<GenericError> {
    private final CsvMapper mapper = new CsvMapper();

    public GenericErrorCsvWriter() {
        this.mapper.enable(CsvGenerator.Feature.ALWAYS_QUOTE_STRINGS);
        this.mapper.enable(new JsonGenerator.Feature[]{JsonGenerator.Feature.IGNORE_UNKNOWN});
    }

    public long getSize(GenericError genericError, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return GenericError.class.isAssignableFrom(type) && MoreMediaTypes.TEXT_CSV_TYPE.isCompatible(mediaType);
    }

    public void writeTo(GenericError genericError, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        if (genericError instanceof ValidationApiError) {
            CsvSchema csvSchema = this.mapper.typedSchemaFor(ApiError.class).withHeader();
            ApiError apiError = ApiError.create(genericError.message());
            this.mapper.writerFor(ApiError.class).with((FormatSchema)csvSchema).writeValue(entityStream, (Object)apiError);
        } else {
            CsvSchema csvSchema = this.mapper.typedSchemaFor(type).withHeader();
            this.mapper.writerFor(type).with((FormatSchema)csvSchema).writeValue(entityStream, (Object)genericError);
        }
    }
}

