/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.datanodes;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.cluster.nodes.NodeService;

@Singleton
public class DatanodeResolver {
    public static final String LEADER_KEYWORD = "leader";
    public static final String ANY_NODE_KEYWORD = "any";
    public static final String ALL_NODES_KEYWORD = "all";
    private final NodeService<DataNodeDto> nodeService;

    @Inject
    public DatanodeResolver(NodeService<DataNodeDto> nodeService) {
        this.nodeService = nodeService;
    }

    public Optional<DataNodeDto> findByHostname(String hostname) {
        Collection<DataNodeDto> datanodes = this.nodeService.allActive().values();
        return datanodes.stream().filter(node -> Objects.equals(node.getHostname(), hostname)).findFirst().or(() -> this.findByKeyword(datanodes, hostname));
    }

    private Optional<DataNodeDto> findByKeyword(Collection<DataNodeDto> datanodes, String hostname) {
        if (hostname != null && hostname.trim().toLowerCase(Locale.ROOT).equals(LEADER_KEYWORD)) {
            return datanodes.stream().filter(NodeDto::isLeader).findFirst();
        }
        if (hostname != null && hostname.trim().toLowerCase(Locale.ROOT).equals(ANY_NODE_KEYWORD)) {
            return datanodes.stream().findFirst();
        }
        return Optional.empty();
    }
}

