/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.search;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.tuple.Pair;
import org.graylog2.rest.resources.entities.EntityAttribute;
import org.graylog2.search.DbFieldMappingCreator;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryOperator;
import org.graylog2.search.SearchQueryOperators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchQueryParser {
    private static final Splitter FIELD_VALUE_SPLITTER = Splitter.on((String)":").limit(2).omitEmptyStrings().trimResults();
    private static final Splitter VALUE_SPLITTER = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private static final String TERM_SPLIT_PATTERN = "(\\S+:(=|=~|<|<=|>|>=)?'(?:[^'\\\\]|\\\\.)*')|(\\S+:(=|=~|<|<=|>|>=)?\"(?:[^\"\\\\]|\\\\.)*\")|['\"][^\\\\]*?(?:\\\\.[^\\\\]*)*?['\"]|\\S+:(=|=~|<|<=|>|>=)?\\S+|\\S+";
    private static final Pattern QUERY_SPLITTER_PATTERN = Pattern.compile("(\\S+:(=|=~|<|<=|>|>=)?'(?:[^'\\\\]|\\\\.)*')|(\\S+:(=|=~|<|<=|>|>=)?\"(?:[^\"\\\\]|\\\\.)*\")|['\"][^\\\\]*?(?:\\\\.[^\\\\]*)*?['\"]|\\S+:(=|=~|<|<=|>|>=)?\\S+|\\S+");
    private static final String INVALID_ENTRY_MESSAGE = "Chunk [%s] is not a valid entry";
    private static final String QUOTE_REPLACE_REGEX = "^[\"']|[\"']$";
    public static final SearchQueryOperator DEFAULT_STRING_OPERATOR = SearchQueryOperators.REGEXP;
    public static final SearchQueryOperator DEFAULT_OPERATOR = SearchQueryOperators.EQUALS;
    private static final Logger LOG = LoggerFactory.getLogger(SearchQueryParser.class);
    @Nonnull
    private final Map<String, SearchQueryField> dbFieldMapping;
    @Nonnull
    private final String defaultField;
    private final SearchQueryField defaultFieldKey;
    private String fieldPrefix = "";

    public SearchQueryParser(@Nonnull String defaultField, @Nonnull Set<String> allowedFields) {
        this(defaultField, allowedFields.stream().collect(Collectors.toMap(Function.identity(), SearchQueryField::create)));
    }

    public SearchQueryParser(@Nonnull String defaultField, @Nonnull Set<String> allowedFields, String fieldPrefix) {
        this(defaultField, allowedFields);
        this.fieldPrefix = fieldPrefix;
    }

    public SearchQueryParser(@Nonnull String defaultField, @Nonnull Map<String, SearchQueryField> allowedFieldsWithMapping) {
        this.defaultField = Objects.requireNonNull(defaultField);
        this.defaultFieldKey = SearchQueryField.create(defaultField, SearchQueryField.Type.STRING);
        this.dbFieldMapping = allowedFieldsWithMapping;
    }

    public SearchQueryParser(@Nonnull String defaultField, @Nonnull List<EntityAttribute> attributes) {
        this.defaultField = Objects.requireNonNull(defaultField);
        this.defaultFieldKey = SearchQueryField.create(defaultField, SearchQueryField.Type.STRING);
        this.dbFieldMapping = DbFieldMappingCreator.createFromEntityAttributes(attributes);
    }

    @VisibleForTesting
    Matcher querySplitterMatcher(String queryString) {
        return QUERY_SPLITTER_PATTERN.matcher(queryString);
    }

    public SearchQuery parse(String encodedQueryString) {
        String queryString = encodedQueryString;
        if (Strings.isNullOrEmpty((String)queryString) || "*".equals(queryString)) {
            return new SearchQuery(queryString);
        }
        try {
            queryString = URLDecoder.decode(encodedQueryString, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("Could not find correct character set for decoding: {}", (Object)e.getMessage());
        }
        Matcher matcher = this.querySplitterMatcher(Objects.requireNonNull(queryString).trim());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        ImmutableSet.Builder disallowedKeys = ImmutableSet.builder();
        while (matcher.find()) {
            String entry = matcher.group();
            if (!entry.contains(":")) {
                builder.put((Object)this.withPrefixIfNeeded(this.defaultField), (Object)this.createFieldValue(this.defaultFieldKey.getFieldType(), entry, false));
                continue;
            }
            Iterator entryFields = FIELD_VALUE_SPLITTER.splitToList((CharSequence)entry).iterator();
            Preconditions.checkArgument((boolean)entryFields.hasNext(), (String)INVALID_ENTRY_MESSAGE, (Object)entry);
            String key = (String)entryFields.next();
            if (!entryFields.hasNext()) continue;
            boolean negate = key.startsWith("-");
            String cleanKey = key.replaceFirst("^-", "");
            String value = (String)entryFields.next();
            VALUE_SPLITTER.splitToList((CharSequence)value).forEach(v -> {
                SearchQueryField translatedKey;
                if (!this.dbFieldMapping.containsKey(cleanKey)) {
                    disallowedKeys.add((Object)cleanKey);
                }
                if ((translatedKey = this.dbFieldMapping.get(cleanKey)) != null) {
                    builder.put((Object)this.withPrefixIfNeeded(translatedKey.getDbField()), (Object)this.createFieldValue(translatedKey.getFieldType(), (String)v, negate));
                } else {
                    builder.put((Object)this.withPrefixIfNeeded(this.defaultField), (Object)this.createFieldValue(this.defaultFieldKey.getFieldType(), (String)v, negate));
                }
            });
            Preconditions.checkArgument((!entryFields.hasNext() ? 1 : 0) != 0, (String)INVALID_ENTRY_MESSAGE, (Object)entry);
        }
        return new SearchQuery(queryString, (Multimap<String, FieldValue>)builder.build(), (Set<String>)disallowedKeys.build());
    }

    private String withPrefixIfNeeded(String fieldName) {
        if (this.fieldPrefix == null || this.fieldPrefix.isEmpty()) {
            return fieldName;
        }
        return this.fieldPrefix + fieldName;
    }

    @VisibleForTesting
    Pair<String, SearchQueryOperator> extractOperator(String value, SearchQueryOperator defaultOperator) {
        if (value.length() >= 3) {
            String substring2;
            switch (substring2 = value.substring(0, 2)) {
                case ">=": {
                    return Pair.of((Object)value.substring(2).trim(), (Object)SearchQueryOperators.GREATER_EQUALS);
                }
                case "<=": {
                    return Pair.of((Object)value.substring(2).trim(), (Object)SearchQueryOperators.LESS_EQUALS);
                }
                case "=~": {
                    return Pair.of((Object)value.substring(2).trim(), (Object)SearchQueryOperators.REGEXP);
                }
            }
        }
        if (value.length() >= 2) {
            String substring1;
            switch (substring1 = value.substring(0, 1)) {
                case ">": {
                    return Pair.of((Object)value.substring(1).trim(), (Object)SearchQueryOperators.GREATER);
                }
                case "<": {
                    return Pair.of((Object)value.substring(1).trim(), (Object)SearchQueryOperators.LESS);
                }
                case "=": {
                    return Pair.of((Object)value.substring(1).trim(), (Object)SearchQueryOperators.EQUALS);
                }
            }
        }
        return Pair.of((Object)value, (Object)defaultOperator);
    }

    @VisibleForTesting
    FieldValue createFieldValue(SearchQueryField.Type fieldType, String quotedStringValue, boolean negate) {
        String value = quotedStringValue.replaceAll(QUOTE_REPLACE_REGEX, "");
        Pair<String, SearchQueryOperator> pair = this.extractOperator(value, fieldType == SearchQueryField.Type.STRING ? DEFAULT_STRING_OPERATOR : DEFAULT_OPERATOR);
        return new FieldValue(fieldType.getMongoValueConverter().apply((String)pair.getLeft()), (SearchQueryOperator)pair.getRight(), negate);
    }

    public static class FieldValue {
        private final Object value;
        private final SearchQueryOperator operator;
        private final boolean negate;

        public FieldValue(Object value, boolean negate) {
            this(value, DEFAULT_STRING_OPERATOR, negate);
        }

        public FieldValue(Object value, SearchQueryOperator operator, boolean negate) {
            this.value = Objects.requireNonNull(value);
            this.operator = operator;
            this.negate = negate;
        }

        public Object getValue() {
            return this.value;
        }

        public SearchQueryOperator getOperator() {
            return this.operator;
        }

        public boolean isNegate() {
            return this.negate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldValue)) {
                return false;
            }
            FieldValue that = (FieldValue)o;
            return this.isNegate() == that.isNegate() && Objects.equals(this.getOperator(), that.getOperator()) && Objects.equals(this.getValue(), that.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getValue(), this.isNegate());
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("operator", (Object)this.operator.getClass().getCanonicalName()).add("negate", this.negate).toString();
        }
    }
}

