/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.security;

import jakarta.annotation.Priority;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.rest.RestTools;
import org.graylog2.shared.security.ContextAwarePermissionAnnotationHandler;
import org.graylog2.shared.security.ShiroSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
public class ShiroAuthorizationFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(ShiroAuthorizationFilter.class);
    private final RequiresPermissions annotation;

    public ShiroAuthorizationFilter(RequiresPermissions annotation) {
        this.annotation = annotation;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        SecurityContext securityContext = requestContext.getSecurityContext();
        if (securityContext instanceof ShiroSecurityContext) {
            ShiroSecurityContext context = (ShiroSecurityContext)securityContext;
            String userId = RestTools.getUserIdFromRequest(requestContext);
            ContextAwarePermissionAnnotationHandler annotationHandler = new ContextAwarePermissionAnnotationHandler(context);
            Object[] requiredPermissions = this.annotation.value();
            try {
                LOG.debug("Checking authorization for user [{}], needs permissions: {}", (Object)userId, (Object)requiredPermissions);
                annotationHandler.assertAuthorized((Annotation)this.annotation);
            }
            catch (AuthorizationException e) {
                LOG.info("Not authorized. User <{}> is missing permissions {} to perform <{} {}>", new Object[]{userId, Arrays.toString(requiredPermissions), requestContext.getMethod(), requestContext.getUriInfo().getPath()});
                throw new ForbiddenException("Not authorized");
            }
        } else {
            throw new ForbiddenException();
        }
    }
}

