/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.storage.providers;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.graylog2.configuration.IndexerHosts;
import org.graylog2.storage.SearchVersion;
import org.graylog2.storage.providers.AtomicCache;
import org.graylog2.storage.versionprobe.ElasticsearchProbeException;
import org.graylog2.storage.versionprobe.VersionProbe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ElasticsearchVersionProvider
implements Provider<SearchVersion> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticsearchVersionProvider.class);
    public static final String NO_HOST_REACHABLE_ERROR = "Unable to probe any host for Elasticsearch version";
    private final Optional<SearchVersion> versionOverride;
    private final List<URI> elasticsearchHosts;
    private final VersionProbe versionProbe;
    private final AtomicCache<Optional<SearchVersion>> cachedVersion;

    @Inject
    public ElasticsearchVersionProvider(@Named(value="elasticsearch_version") @Nullable SearchVersion versionOverride, @IndexerHosts List<URI> elasticsearchHosts, VersionProbe versionProbe, AtomicCache<Optional<SearchVersion>> cachedVersion) {
        this.versionOverride = Optional.ofNullable(versionOverride);
        this.elasticsearchHosts = elasticsearchHosts;
        this.versionProbe = versionProbe;
        this.cachedVersion = cachedVersion;
    }

    public SearchVersion get() {
        if (this.versionOverride.isPresent()) {
            SearchVersion explicitVersion = this.versionOverride.get();
            LOG.info("Elasticsearch version set to " + String.valueOf(explicitVersion) + " - disabling version probe.");
            return explicitVersion;
        }
        try {
            return (SearchVersion)this.cachedVersion.get(() -> {
                Optional<SearchVersion> probedVersion = this.versionProbe.probe(this.elasticsearchHosts);
                probedVersion.ifPresent(version -> LOG.info("Elasticsearch cluster is running " + String.valueOf(version)));
                return probedVersion;
            }).orElseThrow(() -> new ElasticsearchProbeException("Unable to probe any host for Elasticsearch version!"));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new ElasticsearchProbeException("Unable to probe any host for Elasticsearch version: ", e);
        }
    }
}

