/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.system.activities;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.bson.types.ObjectId;
import org.graylog2.database.DbEntity;
import org.graylog2.database.PersistedImpl;
import org.graylog2.database.validators.DateValidator;
import org.graylog2.database.validators.FilledStringValidator;
import org.graylog2.plugin.database.validators.Validator;
import org.graylog2.system.activities.SystemMessage;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@DbEntity(collection="system_messages", titleField="content", readPermission="systemmessages:read")
public class SystemMessageImpl
extends PersistedImpl
implements SystemMessage {
    private final String caller;
    private final String content;
    private final DateTime timestamp;
    private final String nodeId;

    public SystemMessageImpl(Map<String, Object> fields) {
        super(fields);
        this.caller = fields.get("caller").toString();
        this.content = fields.get("content").toString();
        this.timestamp = new DateTime((Object)fields.get("timestamp").toString(), DateTimeZone.UTC);
        this.nodeId = fields.get("node_id").toString();
    }

    protected SystemMessageImpl(ObjectId id, Map<String, Object> fields) {
        super(id, fields);
        this.caller = (String)fields.get("caller");
        this.content = (String)fields.get("content");
        this.timestamp = new DateTime(fields.get("timestamp"), DateTimeZone.UTC);
        this.nodeId = (String)fields.get("node_id");
    }

    @Override
    public String getCaller() {
        return this.caller;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getNodeId() {
        return this.nodeId;
    }

    @Override
    public Map<String, Validator> getValidations() {
        return ImmutableMap.of((Object)"caller", (Object)new FilledStringValidator(), (Object)"content", (Object)new FilledStringValidator(), (Object)"node_id", (Object)new FilledStringValidator(), (Object)"timestamp", (Object)new DateValidator());
    }

    @Override
    public Map<String, Validator> getEmbeddedValidations(String key) {
        return Collections.emptyMap();
    }
}

