/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.annotations.VisibleForTesting;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.collections4.trie.PatriciaTrie;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CIDRPatriciaTrie {
    private PatriciaTrie<Node> trie = new PatriciaTrie();
    private int shortestV4Prefix = -1;
    private int shortestV6Prefix = -1;

    @VisibleForTesting
    boolean isEmpty() {
        return this.trie.isEmpty();
    }

    public CIDRPatriciaTrie cleanCopy() {
        long now = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
        PatriciaTrie cleanTrie = new PatriciaTrie();
        int shortestV6 = -1;
        int shortestV4 = -1;
        for (Map.Entry entry : this.trie.entrySet()) {
            Node data = (Node)entry.getValue();
            if (data.expireAfter != 0L && data.expireAfter <= now) continue;
            int prefixLength = ((String)entry.getKey()).length();
            if (data.rangeIsIPv6 && (shortestV6 == -1 || prefixLength < shortestV6)) {
                shortestV6 = prefixLength;
            } else if (!(data.rangeIsIPv6 || shortestV4 != -1 && prefixLength >= shortestV4)) {
                shortestV4 = prefixLength;
            }
            cleanTrie.put((Object)((String)entry.getKey()), (Object)new Node(data.rangeName, data.rangeIsIPv6, data.expireAfter));
        }
        CIDRPatriciaTrie copy = new CIDRPatriciaTrie();
        copy.trie = cleanTrie;
        copy.shortestV4Prefix = shortestV4;
        copy.shortestV6Prefix = shortestV6;
        return copy;
    }

    public void insertCIDR(String cidr, String rangeName) {
        this.insertCIDR(cidr, rangeName, 0L);
    }

    public void insertCIDR(String cidr, String rangeName, long expireAfter) {
        int prefixLength;
        String[] parts = cidr.split("/");
        String ip = parts[0];
        try {
            prefixLength = Integer.parseInt(parts[1]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Unable to parse invalid CIDR range: " + cidr);
        }
        String binaryIP = CIDRPatriciaTrie.toBinaryString(ip, prefixLength);
        boolean isIPV6 = ip.contains(":");
        Node node = new Node(rangeName, isIPV6, expireAfter);
        this.trie.put((Object)binaryIP, (Object)node);
        if (isIPV6 && (this.shortestV6Prefix == -1 || prefixLength < this.shortestV6Prefix)) {
            this.shortestV6Prefix = prefixLength;
        } else if (!(isIPV6 || this.shortestV4Prefix != -1 && prefixLength >= this.shortestV4Prefix)) {
            this.shortestV4Prefix = prefixLength;
        }
    }

    public String longestPrefixRangeLookup(String ip) {
        return this.longestPrefixRangeLookupWithTtl(ip, 0L);
    }

    public String longestPrefixRangeLookupWithTtl(String ip, long lookupTimeMillis) {
        if (this.isEmpty()) {
            return null;
        }
        String binaryIP = CIDRPatriciaTrie.toBinaryString(ip, -1);
        boolean lookupIsIPv6 = ip.contains(":");
        int shortestPrefixForType = lookupIsIPv6 ? this.shortestV6Prefix : this.shortestV4Prefix;
        for (int i = binaryIP.length(); i >= shortestPrefixForType; --i) {
            String lookupPrefix = binaryIP.substring(0, i);
            SortedMap prefixTrie = this.trie.prefixMap((Object)lookupPrefix);
            for (Map.Entry entry : prefixTrie.entrySet()) {
                Node rangeData = (Node)entry.getValue();
                String binaryCidr = (String)entry.getKey();
                if (lookupIsIPv6 != rangeData.rangeIsIPv6 || rangeData.expireAfter != 0L && rangeData.expireAfter <= lookupTimeMillis || !binaryIP.startsWith(binaryCidr)) continue;
                return rangeData.rangeName;
            }
        }
        return null;
    }

    public void removeCIDR(String cidr) {
        boolean isIPV6;
        int prefixLength;
        String[] parts = cidr.split("/");
        String ip = parts[0];
        String binaryIP = CIDRPatriciaTrie.toBinaryString(ip, prefixLength = Integer.parseInt(parts[1]));
        Node removedNode = (Node)this.trie.remove((Object)binaryIP);
        if (removedNode != null && ((isIPV6 = ip.contains(":")) && prefixLength == this.shortestV6Prefix || !isIPV6 && prefixLength == this.shortestV4Prefix)) {
            this.recalculateShortestPrefix(isIPV6);
        }
    }

    public void recalculateShortestPrefix(boolean isIPV6) {
        if (this.trie.isEmpty()) {
            this.shortestV4Prefix = -1;
            this.shortestV6Prefix = -1;
        } else {
            int shortest = -1;
            long now = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
            for (Map.Entry entry : this.trie.entrySet()) {
                Node rangeData = (Node)entry.getValue();
                if (rangeData.rangeIsIPv6 != isIPV6 || shortest != -1 && ((String)entry.getKey()).length() >= shortest || rangeData.expireAfter != 0L && rangeData.expireAfter <= now) continue;
                shortest = ((String)entry.getKey()).length();
            }
            if (isIPV6) {
                this.shortestV6Prefix = shortest;
            } else {
                this.shortestV4Prefix = shortest;
            }
        }
    }

    static String toBinaryString(String ip, int prefixLength) {
        boolean isIPv6 = ip.contains(":");
        try {
            String[] hextets;
            StringBuilder binary = new StringBuilder();
            if (!isIPv6) {
                String[] octets;
                for (String octet : octets = ip.split("\\.")) {
                    String binaryOctet = String.format(Locale.ROOT, "%8s", Integer.toBinaryString(Integer.parseInt(octet))).replace(' ', '0');
                    binary.append(binaryOctet);
                }
                return prefixLength > 0 ? binary.substring(0, prefixLength) : binary.toString();
            }
            for (String hextet : hextets = ip.split(":")) {
                if (!hextet.isEmpty()) {
                    String binaryHextet = String.format(Locale.ROOT, "%16s", Integer.toBinaryString(Integer.parseInt(hextet, 16))).replace(' ', '0');
                    binary.append(binaryHextet);
                    continue;
                }
                int missingGroups = 8 - hextets.length + 1;
                binary.append("0000000000000000".repeat(Math.max(0, missingGroups)));
            }
            if (binary.length() < prefixLength) {
                binary.append("0".repeat(prefixLength - binary.length()));
            }
            if (prefixLength == -1) {
                binary.append("0".repeat(Math.max(0, 128 - binary.length())));
            } else if (binary.length() > prefixLength) {
                return binary.substring(0, prefixLength);
            }
            return binary.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid IP address format: " + ip);
        }
    }

    @VisibleForTesting
    Node getNode(String key) {
        return (Node)this.trie.get((Object)key);
    }

    @VisibleForTesting
    record Node(String rangeName, boolean rangeIsIPv6, long expireAfter) {
    }
}

