/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import jakarta.inject.Inject;
import java.util.function.Predicate;
import org.bson.conversions.Bson;
import org.graylog.events.notifications.NotificationDto;
import org.graylog.security.entities.EntityOwnershipService;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.plugin.database.users.User;
import org.graylog2.search.SearchQuery;

public class DBNotificationService
extends PaginatedDbService<NotificationDto> {
    private static final String NOTIFICATION_COLLECTION_NAME = "event_notifications";
    private final EntityOwnershipService entityOwnerShipService;

    @Inject
    public DBNotificationService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper, EntityOwnershipService entityOwnerShipService) {
        super(mongoConnection, mapper, NotificationDto.class, NOTIFICATION_COLLECTION_NAME);
        this.entityOwnerShipService = entityOwnerShipService;
    }

    public PaginatedList<NotificationDto> searchPaginated(SearchQuery query, Predicate<NotificationDto> filter, String sortByField, String sortOrder, int page, int perPage) {
        return this.findPaginatedWithQueryFilterAndSort((Bson)query.toDBQuery(), filter, (Bson)this.getSortBuilder(sortOrder, sortByField), page, perPage);
    }

    public NotificationDto saveWithOwnership(NotificationDto notificationDto, User user) {
        NotificationDto dto = super.save(notificationDto);
        this.entityOwnerShipService.registerNewEventNotification(dto.id(), user);
        return dto;
    }

    @Override
    public int delete(String id) {
        this.entityOwnerShipService.unregisterEventNotification(id);
        return super.delete(id);
    }
}

