/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import java.util.Map;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventDto;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventProcessor;
import org.graylog.events.processor.EventProcessorException;
import org.graylog2.database.NotFoundException;
import org.graylog2.plugin.MessageSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBacklogService {
    private static final Logger LOG = LoggerFactory.getLogger(EventBacklogService.class);
    private final Map<String, EventProcessor.Factory> eventProcessorFactories;
    private final DBEventDefinitionService eventDefinitionService;

    @Inject
    public EventBacklogService(Map<String, EventProcessor.Factory> eventProcessorFactories, DBEventDefinitionService eventDefinitionService) {
        this.eventProcessorFactories = eventProcessorFactories;
        this.eventDefinitionService = eventDefinitionService;
    }

    public ImmutableList<MessageSummary> getMessagesForEvent(EventDto eventDto, long backlogSize) throws NotFoundException {
        if (backlogSize <= 0L) {
            return ImmutableList.of();
        }
        EventProcessor.Factory factory = this.eventProcessorFactories.get(eventDto.eventDefinitionType());
        if (factory == null) {
            throw new NotFoundException("Couldn't find event processor factory for type " + eventDto.eventDefinitionType());
        }
        EventDefinition eventDefinition = this.eventDefinitionService.get(eventDto.eventDefinitionId()).orElseThrow(() -> new NotFoundException("Could not find event definition <" + eventDto.eventDefinitionId() + ">"));
        Object eventProcessor = factory.create(eventDefinition);
        ImmutableList.Builder backlogBuilder = ImmutableList.builder();
        try {
            eventProcessor.sourceMessagesForEvent(Event.fromDto(eventDto), arg_0 -> ((ImmutableList.Builder)backlogBuilder).addAll(arg_0), backlogSize);
        }
        catch (EventProcessorException e) {
            LOG.error("Failed to query backlog messages for Event {}", (Object)eventDto.id(), (Object)e);
        }
        return backlogBuilder.build();
    }
}

