/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import jakarta.validation.constraints.NotBlank;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.EmailEventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.events.notifications.types.AutoValue_EmailEventNotificationConfig;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;
import org.joda.time.DateTimeZone;

@JsonTypeName(value="email-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class EmailEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "email-notification-v1";
    private static final String DEFAULT_SENDER = "graylog@example.org";
    static final String DEFAULT_SUBJECT = "Graylog event notification: ${event_definition_title}";
    static final String DEFAULT_BODY_TEMPLATE = "--- [Event Definition] ---------------------------\nTitle:       ${event_definition_title}\nDescription: ${event_definition_description}\nType:        ${event_definition_type}\n--- [Event] --------------------------------------\nAlert Replay:         ${http_external_uri}alerts/${event.id}/replay-search\nTimestamp:            ${event.timestamp}\nMessage:              ${event.message}\nSource:               ${event.source}\nKey:                  ${event.key}\nPriority:             ${event.priority}\nAlert:                ${event.alert}\nTimestamp Processing: ${event.timestamp}\nTimerange Start:      ${event.timerange_start}\nTimerange End:        ${event.timerange_end}\nSource Streams:       ${event.source_streams}\nFields:\n${foreach event.fields field}  ${field.key}: ${field.value}\n${end}\n${if backlog}\n--- [Backlog] ------------------------------------\nLast messages accounting for this alert:\n${foreach backlog message}\n${message}\n\n${end}\n${end}\n\n";
    private static final String FIELD_SENDER = "sender";
    private static final String FIELD_REPLY_TO = "reply_to";
    private static final String FIELD_SUBJECT = "subject";
    private static final String FIELD_BODY_TEMPLATE = "body_template";
    private static final String FIELD_HTML_BODY_TEMPLATE = "html_body_template";
    private static final String FIELD_EMAIL_RECIPIENTS = "email_recipients";
    private static final String FIELD_USER_RECIPIENTS = "user_recipients";
    private static final String FIELD_TIME_ZONE = "time_zone";
    private static final String FIELD_LOOKUP_RECIPIENT_EMAILS = "lookup_recipient_emails";
    private static final String FIELD_RECIPIENTS_LOOKUP_TABLE_NAME = "recipients_lut_name";
    private static final String FIELD_RECIPIENTS_LOOKUP_TABLE_KEY = "recipients_lut_key";
    private static final String FIELD_LOOKUP_SENDER_EMAIL = "lookup_sender_email";
    private static final String FIELD_SENDER_LOOKUP_TABLE_NAME = "sender_lut_name";
    private static final String FIELD_SENDER_LOOKUP_TABLE_KEY = "sender_lut_key";
    private static final String FIELD_LOOKUP_REPLY_TO_EMAIL = "lookup_reply_to_email";
    private static final String FIELD_REPLY_TO_LOOKUP_TABLE_NAME = "reply_to_lut_name";
    private static final String FIELD_REPLY_TO_LOOKUP_TABLE_KEY = "reply_to_lut_key";

    @JsonProperty(value="sender")
    public abstract String sender();

    @JsonProperty(value="reply_to")
    public abstract String replyTo();

    @JsonProperty(value="subject")
    @NotBlank
    public abstract String subject();

    @JsonProperty(value="body_template")
    public abstract String bodyTemplate();

    @JsonProperty(value="html_body_template")
    public abstract String htmlBodyTemplate();

    @JsonProperty(value="email_recipients")
    public abstract Set<String> emailRecipients();

    @JsonProperty(value="user_recipients")
    public abstract Set<String> userRecipients();

    @JsonProperty(value="time_zone")
    public abstract DateTimeZone timeZone();

    @JsonProperty(value="lookup_recipient_emails")
    public abstract boolean lookupRecipientEmails();

    @JsonProperty(value="recipients_lut_name")
    @Nullable
    public abstract String recipientsLUTName();

    @JsonProperty(value="recipients_lut_key")
    @Nullable
    public abstract String recipientsLUTKey();

    @JsonProperty(value="lookup_sender_email")
    public abstract boolean lookupSenderEmail();

    @JsonProperty(value="sender_lut_name")
    @Nullable
    public abstract String senderLUTName();

    @JsonProperty(value="sender_lut_key")
    @Nullable
    public abstract String senderLUTKey();

    @JsonProperty(value="lookup_reply_to_email")
    public abstract boolean lookupReplyToEmail();

    @JsonProperty(value="reply_to_lut_name")
    @Nullable
    public abstract String replyToLUTName();

    @JsonProperty(value="reply_to_lut_key")
    @Nullable
    public abstract String replyToLUTKey();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.subject().isEmpty()) {
            validation.addError(FIELD_SUBJECT, "Email Notification subject cannot be empty.");
        }
        if (this.bodyTemplate().isEmpty() && this.htmlBodyTemplate().isEmpty()) {
            validation.addError("body", "One of Email Notification body template or Email Notification HTML body must not be empty.");
        }
        if (!this.lookupRecipientEmails() && this.emailRecipients().isEmpty() && this.userRecipients().isEmpty()) {
            validation.addError("recipients", "Email Notification must have email recipients or user recipients.");
        }
        if (this.lookupRecipientEmails()) {
            if (Strings.isNullOrEmpty((String)this.recipientsLUTName())) {
                validation.addError(FIELD_RECIPIENTS_LOOKUP_TABLE_NAME, "Lookup table name must not be empty");
            }
            if (Strings.isNullOrEmpty((String)this.recipientsLUTKey())) {
                validation.addError(FIELD_RECIPIENTS_LOOKUP_TABLE_KEY, "Lookup table key must not be empty");
            }
        }
        if (this.lookupSenderEmail()) {
            if (Strings.isNullOrEmpty((String)this.senderLUTName())) {
                validation.addError(FIELD_SENDER_LOOKUP_TABLE_NAME, "Lookup table name must not be empty");
            }
            if (Strings.isNullOrEmpty((String)this.senderLUTKey())) {
                validation.addError(FIELD_SENDER_LOOKUP_TABLE_KEY, "Lookup table key must not be empty");
            }
        }
        if (this.lookupReplyToEmail()) {
            if (Strings.isNullOrEmpty((String)this.replyToLUTName())) {
                validation.addError(FIELD_REPLY_TO_LOOKUP_TABLE_NAME, "Lookup table name must not be empty");
            }
            if (Strings.isNullOrEmpty((String)this.replyToLUTKey())) {
                validation.addError(FIELD_REPLY_TO_LOOKUP_TABLE_KEY, "Lookup table key must not be empty");
            }
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        EmailEventNotificationConfigEntity.Builder builder = EmailEventNotificationConfigEntity.builder().sender(ValueReference.of(this.sender())).replyTo(ValueReference.of(this.replyTo())).subject(ValueReference.of(this.subject())).bodyTemplate(ValueReference.of(this.bodyTemplate())).htmlBodyTemplate(ValueReference.of(this.htmlBodyTemplate())).emailRecipients(this.emailRecipients()).userRecipients(this.userRecipients()).timeZone(ValueReference.of(this.timeZone().getID())).lookupRecipientEmails(ValueReference.of(this.lookupRecipientEmails())).lookupSenderEmail(ValueReference.of(this.lookupSenderEmail())).lookupReplyToEmail(ValueReference.of(this.lookupReplyToEmail()));
        if (this.lookupRecipientEmails()) {
            builder.recipientsLUTName(ValueReference.ofNullable(this.recipientsLUTName())).recipientsLUTKey(ValueReference.ofNullable(this.recipientsLUTKey()));
        } else {
            builder.recipientsLUTName(ValueReference.of("")).recipientsLUTKey(ValueReference.of(""));
        }
        if (this.lookupSenderEmail()) {
            builder.senderLUTName(ValueReference.ofNullable(this.senderLUTName())).senderLUTKey(ValueReference.ofNullable(this.senderLUTKey()));
        } else {
            builder.senderLUTName(ValueReference.of("")).senderLUTKey(ValueReference.of(""));
        }
        if (this.lookupReplyToEmail()) {
            builder.replyToLUTName(ValueReference.ofNullable(this.replyToLUTName())).replyToLUTKey(ValueReference.ofNullable(this.replyToLUTKey()));
        } else {
            builder.replyToLUTName(ValueReference.of("")).replyToLUTKey(ValueReference.of(""));
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_EmailEventNotificationConfig.Builder().type(EmailEventNotificationConfig.TYPE_NAME).sender(EmailEventNotificationConfig.DEFAULT_SENDER).replyTo("").subject(EmailEventNotificationConfig.DEFAULT_SUBJECT).emailRecipients((Set<String>)ImmutableSet.of()).userRecipients((Set<String>)ImmutableSet.of()).bodyTemplate(EmailEventNotificationConfig.DEFAULT_BODY_TEMPLATE).timeZone(DateTimeZone.UTC).htmlBodyTemplate("").lookupRecipientEmails(false).lookupSenderEmail(false).lookupReplyToEmail(false);
        }

        @JsonProperty(value="sender")
        public abstract Builder sender(String var1);

        @JsonProperty(value="reply_to")
        public abstract Builder replyTo(String var1);

        @JsonProperty(value="subject")
        public abstract Builder subject(String var1);

        @JsonProperty(value="body_template")
        public abstract Builder bodyTemplate(String var1);

        @JsonProperty(value="html_body_template")
        public abstract Builder htmlBodyTemplate(String var1);

        @JsonProperty(value="email_recipients")
        public abstract Builder emailRecipients(Set<String> var1);

        @JsonProperty(value="user_recipients")
        public abstract Builder userRecipients(Set<String> var1);

        @JsonProperty(value="time_zone")
        public abstract Builder timeZone(DateTimeZone var1);

        @JsonProperty(value="lookup_recipient_emails")
        public abstract Builder lookupRecipientEmails(boolean var1);

        @JsonProperty(value="recipients_lut_name")
        public abstract Builder recipientsLUTName(String var1);

        @JsonProperty(value="recipients_lut_key")
        public abstract Builder recipientsLUTKey(String var1);

        @JsonProperty(value="lookup_sender_email")
        public abstract Builder lookupSenderEmail(boolean var1);

        @JsonProperty(value="sender_lut_name")
        public abstract Builder senderLUTName(String var1);

        @JsonProperty(value="sender_lut_key")
        public abstract Builder senderLUTKey(String var1);

        @JsonProperty(value="lookup_reply_to_email")
        public abstract Builder lookupReplyToEmail(boolean var1);

        @JsonProperty(value="reply_to_lut_name")
        public abstract Builder replyToLUTName(String var1);

        @JsonProperty(value="reply_to_lut_key")
        public abstract Builder replyToLUTKey(String var1);

        public abstract EmailEventNotificationConfig build();
    }
}

