/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.integrations.dataadapters;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.inject.assistedinject.Assisted;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONObject;
import jakarta.inject.Inject;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.graylog.integrations.dataadapters.AutoValue_GreyNoiseQuickIPDataAdapter_Config;
import org.graylog.plugins.threatintel.tools.AdapterDisabledException;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.security.encryption.EncryptedValue;
import org.graylog2.security.encryption.EncryptedValueService;
import org.graylog2.utilities.ReservedIpChecker;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreyNoiseQuickIPDataAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(GreyNoiseQuickIPDataAdapter.class);
    public static final String NAME = "GreyNoise";
    static final String GREYNOISE_IPQC_ENDPOINT = "https://api.greynoise.io/v2/noise/quick/";
    private final EncryptedValueService encryptedValueService;
    private final Config config;
    private final OkHttpClient okHttpClient;
    private static final AtomicBoolean VALID_GREYNOISE_LICENSE = new AtomicBoolean(false);

    @Inject
    public GreyNoiseQuickIPDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry, EncryptedValueService encryptedValueService, OkHttpClient okHttpClient) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.encryptedValueService = encryptedValueService;
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void doStart() throws Exception {
        if (!this.isValidSubscription(this.encryptedValueService.decrypt(this.config.apiToken()))) {
            VALID_GREYNOISE_LICENSE.set(false);
            throw new AdapterDisabledException("Cannot start Data Adapter without a GreyNoise Enterprise subscription. Check API key and restart Data Adapter.");
        }
        VALID_GREYNOISE_LICENSE.set(true);
    }

    @Override
    public void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
    }

    @Override
    protected LookupResult doGet(Object keyObject) {
        LookupResult lookupResult;
        block13: {
            if (!VALID_GREYNOISE_LICENSE.get()) {
                return LookupResult.withError("Cannot perform lookup without a GreyNoise Enterprise subscription. Check API key and restart Data Adapter.");
            }
            String ip = keyObject.toString();
            if (InetAddressValidator.getInstance().isValidInet4Address(ip)) {
                if (ReservedIpChecker.getInstance().isReservedIpAddress(ip)) {
                    LOG.info("'{}' is an unsupported reserved address. Skipping lookup.", (Object)ip);
                    return LookupResult.empty();
                }
            } else {
                if (InetAddressValidator.getInstance().isValidInet6Address(ip)) {
                    LOG.info("'{}' is an unsupported IPv6 address. Skipping lookup.", (Object)ip);
                    return LookupResult.empty();
                }
                LOG.error("'{}' is not a valid IPv4 Address", (Object)ip);
                return LookupResult.withError();
            }
            Request request = new Request.Builder().url(GREYNOISE_IPQC_ENDPOINT + ip).method("GET", null).addHeader("Accept", "application/json").addHeader("key", this.encryptedValueService.decrypt(this.config.apiToken())).addHeader("User-Agent", "Graylog").build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                lookupResult = GreyNoiseQuickIPDataAdapter.parseResponse(response);
                if (response == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.error("An error occurred while retrieving lookup result [{}]", (Object)e.toString());
                    return LookupResult.withError();
                }
            }
            response.close();
        }
        return lookupResult;
    }

    @VisibleForTesting
    static LookupResult parseResponse(Response response) {
        if (response.isSuccessful()) {
            HashMap map = Maps.newHashMap();
            try {
                JSONObject obj = new JSONObject(response.body().string());
                map.put("ip", Objects.requireNonNull(obj).getFieldAsString("ip"));
                map.put("noise", Objects.requireNonNull(obj).getFieldAsBoolean("noise"));
                map.put("code", Objects.requireNonNull(obj).getFieldAsString("code"));
                map.put("riot", Objects.requireNonNull(obj).getFieldAsBoolean("riot"));
            }
            catch (JSONException | IOException e) {
                LOG.error("An error occurred while parsing Lookup result [{}]", (Object)e.toString());
            }
            return LookupResult.withoutTTL().multiValue(map).build();
        }
        return LookupResult.empty();
    }

    @Override
    public void set(Object key, Object value) {
    }

    private boolean isValidSubscription(String apiKey) {
        boolean bl;
        block8: {
            Request request = new Request.Builder().url("https://api.greynoise.io/ping").method("GET", null).addHeader("Accept", "application/json").addHeader("key", apiKey).addHeader("User-Agent", "Graylog").build();
            Response response = this.okHttpClient.newCall(request).execute();
            try {
                JSONObject json = new JSONObject(response.body().string());
                boolean bl2 = bl = response.isSuccessful() && json.hasField("offering") && !json.getFieldAsString("offering").equals("community");
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOG.warn("An error occurred while retrieving subscription type.", (Throwable)e);
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="GreyNoise")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="api_token")
        @NotEmpty
        public abstract EncryptedValue apiToken();

        public static Builder builder() {
            return new AutoValue_GreyNoiseQuickIPDataAdapter_Config.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return Config.builder();
            }

            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="api_token")
            public abstract Builder apiToken(EncryptedValue var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(GreyNoiseQuickIPDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(GreyNoiseQuickIPDataAdapter.NAME).apiToken(EncryptedValue.createUnset()).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<GreyNoiseQuickIPDataAdapter> {
        @Override
        public GreyNoiseQuickIPDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

