/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.metrics.prometheus.mapping.PrometheusMappingConfigLoader;
import org.graylog2.plugin.utilities.FileInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMappingFilesHandler {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusMappingFilesHandler.class);
    static final String CORE_MAPPING_RESOURCE = "prometheus-exporter.yml";
    @Nullable
    private final Path coreMappingFile;
    @Nullable
    private final Path customMappingFile;
    private final String coreMappingResource;
    private final PrometheusMappingConfigLoader mapperConfigLoader;
    private final AtomicReference<FileInfo> coreMappingFileInfoRef = new AtomicReference<Object>(null);
    private final AtomicReference<FileInfo> customMappingFileInfoRef = new AtomicReference<Object>(null);

    @Inject
    public PrometheusMappingFilesHandler(@Named(value="prometheus_exporter_mapping_file_path_core") @Nullable Path coreMappingPath, @Named(value="prometheus_exporter_mapping_file_path_custom") @Nullable Path customMappingPath, PrometheusMappingConfigLoader mapperConfigLoader) {
        this(coreMappingPath, customMappingPath, CORE_MAPPING_RESOURCE, mapperConfigLoader);
    }

    @VisibleForTesting
    PrometheusMappingFilesHandler(@Named(value="prometheus_exporter_mapping_file_path_core") @Nullable Path coreMappingPath, @Named(value="prometheus_exporter_mapping_file_path_custom") @Nullable Path customMappingPath, String coreMappingResource, PrometheusMappingConfigLoader mapperConfigLoader) {
        this.coreMappingFile = PrometheusMappingFilesHandler.buildPath(coreMappingPath, this.coreMappingFileInfoRef);
        this.customMappingFile = PrometheusMappingFilesHandler.buildPath(customMappingPath, this.customMappingFileInfoRef);
        this.coreMappingResource = coreMappingResource;
        this.mapperConfigLoader = mapperConfigLoader;
    }

    private static Path buildPath(Path file, AtomicReference<FileInfo> fileInfoRef) {
        if (file != null) {
            if (Files.exists(file, new LinkOption[0])) {
                fileInfoRef.set(FileInfo.forPath(file));
            }
            return file.toAbsolutePath();
        }
        return null;
    }

    private Optional<FileInfo.Change> detectChange(@Nullable Path file, AtomicReference<FileInfo> fileInfoRef) {
        if (file != null && Files.exists(file, new LinkOption[0])) {
            LOG.debug("Detecting changes for file <{}>", (Object)file);
            if (fileInfoRef.get() == null) {
                LOG.debug("Getting initial file info for file <{}>", (Object)file);
                FileInfo newFileInfo = FileInfo.forPath(file);
                fileInfoRef.set(newFileInfo);
                return Optional.of(new FileInfo.Change(newFileInfo));
            }
            FileInfo.Change change = fileInfoRef.get().checkForChange();
            if (change.isChanged()) {
                LOG.debug("Updating file info for changed file <{}>", (Object)file);
                fileInfoRef.set(change.fileInfo());
            }
            return Optional.of(change);
        }
        LOG.debug("File <{}> doesn't exist", (Object)file);
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filesHaveChanged() {
        if (!(this.coreMappingFile != null && Files.exists(this.coreMappingFile, new LinkOption[0]) || this.customMappingFile != null && Files.exists(this.customMappingFile, new LinkOption[0]))) {
            return false;
        }
        ArrayList changes = new ArrayList();
        PrometheusMappingFilesHandler prometheusMappingFilesHandler = this;
        synchronized (prometheusMappingFilesHandler) {
            this.detectChange(this.coreMappingFile, this.coreMappingFileInfoRef).ifPresent(changes::add);
            this.detectChange(this.customMappingFile, this.customMappingFileInfoRef).ifPresent(changes::add);
        }
        return changes.stream().anyMatch(FileInfo.Change::isChanged);
    }

    public List<MapperConfig> getMapperConfigs() {
        HashSet<Object> mapperConfigs = new HashSet<Object>();
        if (this.coreMappingFile != null && Files.exists(this.coreMappingFile, new LinkOption[0])) {
            LOG.debug("Loading core metric mappings from file <{}>", (Object)this.coreMappingFile);
            try {
                InputStream inputStream = Files.newInputStream(this.coreMappingFile, StandardOpenOption.READ);
                mapperConfigs.addAll(this.mapperConfigLoader.load(inputStream));
            }
            catch (IOException e) {
                LOG.error("Couldn't load mapping from file <{}>", (Object)this.coreMappingFile, (Object)e);
            }
        } else {
            LOG.debug("Loading core metric mappings from resource <{}>", (Object)this.coreMappingResource);
            try {
                mapperConfigs.addAll(this.mapperConfigLoader.load(Resources.getResource((String)this.coreMappingResource).openStream()));
            }
            catch (IOException e) {
                LOG.error("Couldn't load mapping from resource <{}>", (Object)this.coreMappingResource, (Object)e);
            }
        }
        if (this.customMappingFile != null && Files.exists(this.customMappingFile, new LinkOption[0])) {
            LOG.debug("Loading custom metric mappings from file <{}>", (Object)this.customMappingFile);
            try {
                Set coreMetricNames = mapperConfigs.stream().map(MapperConfig::getName).collect(Collectors.toSet());
                InputStream inputStream = Files.newInputStream(this.customMappingFile, StandardOpenOption.READ);
                Set customConfigs = this.mapperConfigLoader.load(inputStream).stream().filter(config -> {
                    if (coreMetricNames.contains(config.getName())) {
                        LOG.warn("Custom metric mapping config cannot overwrite core metric: {}", (Object)config.getName());
                        return false;
                    }
                    return true;
                }).collect(Collectors.toSet());
                mapperConfigs.addAll(customConfigs);
            }
            catch (IOException e) {
                LOG.error("Couldn't load mapping from file <{}>", (Object)this.coreMappingFile, (Object)e);
            }
        }
        return ImmutableList.copyOf(mapperConfigs);
    }
}

