/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import com.google.inject.assistedinject.Assisted;
import com.maxmind.geoip2.exception.AddressNotFoundException;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import java.util.Optional;
import org.graylog.plugins.map.geoip.GeoAsnInformation;
import org.graylog.plugins.map.geoip.IPinfoASN;
import org.graylog.plugins.map.geoip.IpInfoIpResolver;

public class IpInfoIpAsnResolver
extends IpInfoIpResolver<GeoAsnInformation> {
    @Inject
    public IpInfoIpAsnResolver(@Assisted Timer timer, @Assisted String configPath, @Assisted boolean enabled, @Named(value="geo_ip_processor_disable_ipinfo_db_type_check") boolean disableIpInfoDbTypeCheck) {
        super(timer, configPath, enabled, disableIpInfoDbTypeCheck);
    }

    @Override
    protected Optional<GeoAsnInformation> doGetGeoIpData(InetAddress address) {
        GeoAsnInformation info;
        block8: {
            try (Timer.Context ignored = this.resolveTime.time();){
                IPinfoASN ipInfoASN = this.adapter.ipInfoASN(address);
                info = GeoAsnInformation.create(ipInfoASN.name(), ipInfoASN.type(), ipInfoASN.asn());
            }
            catch (AddressNotFoundException | IOException | UnsupportedOperationException e) {
                info = null;
                if (e instanceof AddressNotFoundException) break block8;
                String error = String.format(Locale.US, "Error getting ASN for IP Address '%s'. %s", address, e.getMessage());
                LOG.warn(error, e);
                this.lastError = e.getMessage();
            }
        }
        return Optional.ofNullable(info);
    }
}

