/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.lookup;

import jakarta.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;
import org.graylog.plugins.pipelineprocessor.rulebuilder.RuleBuilderFunctionGroup;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;

public class LookupHasValue
extends AbstractFunction<Object> {
    public static final String NAME = "lookup_has_value";
    private final ParameterDescriptor<String, LookupTableService.Function> lookupTableParam = ParameterDescriptor.string("lookup_table", LookupTableService.Function.class).description("The existing lookup table to use to lookup the given key").transform(tableName -> lookupTableService.newBuilder().lookupTable((String)tableName).build()).build();
    private final ParameterDescriptor<Object, Object> keyParam = ParameterDescriptor.object("key").description("The key to lookup in the table").build();

    @Inject
    public LookupHasValue(LookupTableService lookupTableService) {
    }

    @Override
    public Boolean evaluate(FunctionArgs args, EvaluationContext context) {
        Object key = this.keyParam.required(args, context);
        if (key == null) {
            return false;
        }
        LookupTableService.Function table = this.lookupTableParam.required(args, context);
        if (table == null) {
            return false;
        }
        LookupResult result = table.lookup(key);
        return result != null && !result.isEmpty();
    }

    @Override
    public FunctionDescriptor<Object> descriptor() {
        return FunctionDescriptor.builder().name(NAME).description("Checks if lookup table contains a given key.").params(this.lookupTableParam, this.keyParam).returnType(Boolean.class).ruleBuilderEnabled().ruleBuilderName("Lookup value check").ruleBuilderTitle("Check if lookup table '${lookup_table}' contains '${value}'").ruleBuilderFunctionGroup(RuleBuilderFunctionGroup.LOOKUP).build();
    }
}

