/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.adapters.otx;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.graylog.plugins.threatintel.adapters.otx.;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTXDataAdapter
extends LookupDataAdapter {
    public static final String NAME = "otx-api";
    private static final Logger LOG = LoggerFactory.getLogger(OTXDataAdapter.class);
    private static final InetAddressValidator INET_ADDRESS_VALIDATOR = InetAddressValidator.getInstance();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final TypeReference<Map<Object, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<Object, Object>>(){};
    private static final String OTX_INDICATOR_IPV4 = "IPv4";
    private static final String OTX_INDICATOR_IPV6 = "IPv6";
    private static final String OTX_INDICATOR_IP_AUTO_DETECT = "IPAutoDetect";
    private static final ImmutableSet<String> OTX_IP_INDICATORS = ImmutableSet.of((Object)"IPv4", (Object)"IPv6");
    private static final String OTX_SECTION = "general";
    private static final ImmutableSet<String> OTX_INDICATORS = ImmutableSet.builder().add((Object)"IPAutoDetect").add((Object)"IPv4").add((Object)"IPv6").add((Object)"domain").add((Object)"hostname").add((Object)"file").add((Object)"url").add((Object)"cve").add((Object)"nids").add((Object)"correlation-rule").build();
    private final Config config;
    private final OkHttpClient httpClient;
    private final Timer httpRequestTimer;
    private final Meter httpRequestErrors;
    private Headers httpHeaders;
    private HttpUrl parsedApiUrl;

    @Inject
    protected OTXDataAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, OkHttpClient httpClient, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
        this.config = (Config)config;
        this.httpClient = httpClient.newBuilder().connectTimeout(this.config.httpConnectTimeout(), TimeUnit.MILLISECONDS).writeTimeout(this.config.httpWriteTimeout(), TimeUnit.MILLISECONDS).readTimeout(this.config.httpReadTimeout(), TimeUnit.MILLISECONDS).build();
        this.httpRequestTimer = metricRegistry.timer(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestTime"}));
        this.httpRequestErrors = metricRegistry.meter(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{"httpRequestErrors"}));
    }

    @Override
    protected void doStart() throws Exception {
        Headers.Builder builder = new Headers.Builder();
        String apiKey = this.config.apiKey();
        if (Strings.isNullOrEmpty((String)apiKey)) {
            LOG.warn("OTX API key is missing. Make sure to add the key to allow higher request limits.");
        } else {
            builder.add("X-OTX-API-KEY", apiKey);
        }
        if (Strings.isNullOrEmpty((String)this.config.indicator())) {
            throw new IllegalArgumentException("OTX indicator is missing");
        }
        if (!OTX_INDICATORS.contains((Object)this.config.indicator())) {
            throw new IllegalArgumentException("Invalid OTX indicator value - allowed: " + String.join((CharSequence)", ", OTX_INDICATORS));
        }
        if (Strings.isNullOrEmpty((String)this.config.httpUserAgent())) {
            throw new IllegalArgumentException("HTTP user-agent is missing");
        }
        if (Strings.isNullOrEmpty((String)this.config.apiUrl())) {
            throw new IllegalArgumentException("OTX API URL is missing");
        }
        HttpUrl parsedUrl = HttpUrl.parse((String)this.config.apiUrl());
        if (parsedUrl == null) {
            throw new IllegalArgumentException("OTX API URL is not valid");
        }
        this.parsedApiUrl = parsedUrl;
        this.httpHeaders = builder.add("User-Agent", this.config.httpUserAgent()).add("Accept", "application/json").build();
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected LookupResult doGet(Object keyObject) {
        String key = String.valueOf(keyObject);
        String otxIndicator = this.config.indicator();
        if (OTX_INDICATOR_IP_AUTO_DETECT.equals(otxIndicator)) {
            Optional<String> ipType = this.detectIpType(key);
            if (ipType.isPresent()) {
                otxIndicator = ipType.get();
            } else {
                LOG.warn("Unable to auto-detect IP address type for key <{}>", (Object)key);
                return LookupResult.empty();
            }
        }
        if (OTX_IP_INDICATORS.contains((Object)otxIndicator) && this.isPrivateIPAddress(key)) {
            LOG.debug("OTX API does not accept private IP address <{}>. Skipping lookup to avoid OTX API request.", (Object)key);
            return LookupResult.empty();
        }
        HttpUrl url = new HttpUrl.Builder().scheme(this.parsedApiUrl.scheme()).host(this.parsedApiUrl.host()).port(this.parsedApiUrl.port()).addPathSegments("/api/v1/indicators").addPathSegment(otxIndicator).addPathSegment(String.valueOf(key)).addPathSegment(OTX_SECTION).build();
        Request request = new Request.Builder().get().url(url).headers(this.httpHeaders).build();
        Timer.Context time = this.httpRequestTimer.time();
        try {
            LookupResult lookupResult;
            block19: {
                Response response;
                block17: {
                    LookupResult lookupResult2;
                    block18: {
                        response = this.httpClient.newCall(request).execute();
                        try {
                            if (response.isSuccessful()) break block17;
                            LOG.warn("OTX {} request for key <{}> failed: {}", new Object[]{otxIndicator, key, response});
                            this.httpRequestErrors.mark();
                            lookupResult2 = LookupResult.withError(String.format(Locale.ENGLISH, "OTX %s request for key <%s> failed: %s", otxIndicator, key, response.code()));
                            if (response == null) break block18;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (response != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOG.error("OTX {} request error for key <{}>", new Object[]{otxIndicator, key, e});
                                this.httpRequestErrors.mark();
                                LookupResult lookupResult3 = LookupResult.empty();
                                return lookupResult3;
                            }
                        }
                        response.close();
                    }
                    return lookupResult2;
                }
                lookupResult = this.parseResponse(response.body());
                if (response == null) break block19;
                response.close();
            }
            return lookupResult;
        }
        finally {
            time.stop();
        }
    }

    @VisibleForTesting
    LookupResult parseResponse(@Nullable ResponseBody body) {
        if (body != null) {
            try {
                JsonNode json = OBJECT_MAPPER.readTree(body.string());
                return LookupResult.withoutTTL().single(json.path("pulse_info").path("count").asLong(0L)).multiValue((Map)OBJECT_MAPPER.convertValue((Object)json, MAP_TYPE_REFERENCE)).build();
            }
            catch (IOException e) {
                LOG.warn("Couldn't parse OTX response as JSON", (Throwable)e);
            }
        }
        return LookupResult.empty();
    }

    @VisibleForTesting
    boolean isPrivateIPAddress(String ip) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ip);
            return inetAddress.isSiteLocalAddress() || inetAddress.isLoopbackAddress() || inetAddress.isAnyLocalAddress();
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    private Optional<String> detectIpType(String ip) {
        if (INET_ADDRESS_VALIDATOR.isValidInet4Address(ip)) {
            return Optional.of(OTX_INDICATOR_IPV4);
        }
        if (INET_ADDRESS_VALIDATOR.isValidInet6Address(ip)) {
            return Optional.of(OTX_INDICATOR_IPV6);
        }
        return Optional.empty();
    }

    @Override
    public void set(Object key, Object value) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=Builder.class)
    @JsonTypeName(value="otx-api")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        @JsonProperty(value="indicator")
        @NotEmpty
        public abstract String indicator();

        @JsonProperty(value="api_key")
        @Nullable
        public abstract String apiKey();

        @JsonProperty(value="api_url")
        @NotEmpty
        public abstract String apiUrl();

        @JsonProperty(value="http_user_agent")
        @NotEmpty
        public abstract String httpUserAgent();

        @JsonProperty(value="http_connect_timeout")
        @Min(value=1L)
        public abstract @Min(value=1L) long httpConnectTimeout();

        @JsonProperty(value="http_write_timeout")
        @Min(value=1L)
        public abstract @Min(value=1L) long httpWriteTimeout();

        @JsonProperty(value="http_read_timeout")
        @Min(value=1L)
        public abstract @Min(value=1L) long httpReadTimeout();

        public static Builder builder() {
            return new .AutoValue_OTXDataAdapter_Config.Builder();
        }

        public abstract Builder toBuilder();

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            if (!OTX_INDICATORS.contains((Object)this.indicator())) {
                errors.put((Object)"indicator", (Object)("Invalid value - allowed: " + String.join((CharSequence)", ", OTX_INDICATORS)));
            }
            if (HttpUrl.parse((String)this.apiUrl()) == null) {
                errors.put((Object)"api_url", (Object)"Invalid URL");
            }
            if (this.httpConnectTimeout() < 1L) {
                errors.put((Object)"http_connect_timeout", (Object)"Value cannot be smaller than 1");
            }
            if (this.httpWriteTimeout() < 1L) {
                errors.put((Object)"http_write_timeout", (Object)"Value cannot be smaller than 1");
            }
            if (this.httpReadTimeout() < 1L) {
                errors.put((Object)"http_read_timeout", (Object)"Value cannot be smaller than 1");
            }
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonCreator
            public static Builder create() {
                return Config.builder().httpConnectTimeout(10000L).httpWriteTimeout(10000L).httpReadTimeout(60000L);
            }

            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="indicator")
            public abstract Builder indicator(String var1);

            @JsonProperty(value="api_key")
            public abstract Builder apiKey(String var1);

            @JsonProperty(value="api_url")
            public abstract Builder apiUrl(String var1);

            @JsonProperty(value="http_user_agent")
            public abstract Builder httpUserAgent(String var1);

            @JsonProperty(value="http_connect_timeout")
            public abstract Builder httpConnectTimeout(long var1);

            @JsonProperty(value="http_write_timeout")
            public abstract Builder httpWriteTimeout(long var1);

            @JsonProperty(value="http_read_timeout")
            public abstract Builder httpReadTimeout(long var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(OTXDataAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(OTXDataAdapter.NAME).indicator(OTXDataAdapter.OTX_INDICATOR_IP_AUTO_DETECT).apiUrl("https://otx.alienvault.com").httpUserAgent("Graylog Threat Intelligence Plugin - https://github.com/Graylog2/graylog-plugin-threatintel").httpConnectTimeout(10000L).httpWriteTimeout(10000L).httpReadTimeout(60000L).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<OTXDataAdapter> {
        @Override
        public OTXDataAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

