/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.Function;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.migrations.AutoValue_V20200409083200_RemoveRootQueriesFromMigratedDashboards_MigrationCompleted;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20200409083200_RemoveRootQueriesFromMigratedDashboards
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20200409083200_RemoveRootQueriesFromMigratedDashboards.class);
    private static final String COLLECTION_NAME_SEARCHES = "searches";
    private static final String COLLECTION_NAME_VIEWS = "views";
    private static final String FIELD_ID = "_id";
    private static final String FIELD_NESTED_QUERY_STRING = "query.query_string";
    private static final String FIELD_SEARCH_ID = "search_id";
    private static final String FIELD_QUERIES = "queries";
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> viewsCollection;
    private final MongoCollection<Document> searchesCollection;

    @Inject
    public V20200409083200_RemoveRootQueriesFromMigratedDashboards(ClusterConfigService clusterConfigService, MongoConnection mongoConnection) {
        this(clusterConfigService, (MongoCollection<Document>)mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME_VIEWS), (MongoCollection<Document>)mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME_SEARCHES));
    }

    @VisibleForTesting
    V20200409083200_RemoveRootQueriesFromMigratedDashboards(ClusterConfigService clusterConfigService, MongoCollection<Document> viewsCollection, MongoCollection<Document> searchesCollection) {
        this.clusterConfigService = clusterConfigService;
        this.viewsCollection = viewsCollection;
        this.searchesCollection = searchesCollection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2020-04-09T08:32:00Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed.");
            return;
        }
        UpdateResult updateResult = this.searchesCollection.updateMany(Filters.and((Bson[])new Bson[]{this.isDashboard(), this.atLeastOneQueryHasNonEmptyQueryString()}), this.makeQueryStringEmpty(), this.forNonEmptyQueryStrings());
        this.writeMigrationCompleted(updateResult.getModifiedCount());
    }

    private MongoIterable<ObjectId> searchIdsForDashboards() {
        return this.viewsCollection.find(this.viewIsDashboard()).projection(this.onlySearchId()).map(this.returnOnlySearchId());
    }

    private Function<Document, ObjectId> returnOnlySearchId() {
        return doc -> new ObjectId(doc.getString((Object)FIELD_SEARCH_ID));
    }

    private Bson onlySearchId() {
        return Projections.fields((Bson[])new Bson[]{Projections.include((String[])new String[]{FIELD_SEARCH_ID}), Projections.excludeId()});
    }

    private UpdateOptions forNonEmptyQueryStrings() {
        return new UpdateOptions().arrayFilters(Collections.singletonList(this.emptyOrAllMatchesQuery("elem.query.query_string")));
    }

    private Bson viewIsDashboard() {
        return Filters.eq((String)"type", (Object)"DASHBOARD");
    }

    private Bson isDashboard() {
        return Filters.in((String)FIELD_ID, this.searchIdsForDashboards());
    }

    private Bson atLeastOneQueryHasNonEmptyQueryString() {
        return Filters.elemMatch((String)FIELD_QUERIES, (Bson)this.emptyOrAllMatchesQuery(FIELD_NESTED_QUERY_STRING));
    }

    private Bson makeQueryStringEmpty() {
        return Updates.set((String)"queries.$[elem].query.query_string", (Object)"");
    }

    private Bson emptyOrAllMatchesQuery(String fieldName) {
        return Filters.or((Bson[])new Bson[]{Filters.ne((String)fieldName, (Object)""), Filters.ne((String)fieldName, (Object)"*")});
    }

    private void writeMigrationCompleted(long migratedViewsCount) {
        this.clusterConfigService.write(MigrationCompleted.create(migratedViewsCount));
    }

    @JsonAutoDetect
    @AutoValue
    public static abstract class MigrationCompleted {
        @JsonProperty(value="modified_views_count")
        public abstract long modifiedViewsCount();

        @JsonCreator
        public static MigrationCompleted create(@JsonProperty(value="modified_views_count") long modifiedViewsCount) {
            return new AutoValue_V20200409083200_RemoveRootQueriesFromMigratedDashboards_MigrationCompleted(modifiedViewsCount);
        }
    }
}

