/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.configuration;

import com.google.common.base.Suppliers;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.net.URI;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.graylog2.bootstrap.preflight.PreflightConfigResult;
import org.graylog2.bootstrap.preflight.PreflightConfigService;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunsWithDataNodeDiscoveryProvider
implements Provider<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(RunsWithDataNodeDiscoveryProvider.class);
    private final PreflightConfigService preflightConfigService;
    private final NodeService<DataNodeDto> nodeService;
    private final Supplier<Boolean> resultsCachingSupplier;

    @Inject
    public RunsWithDataNodeDiscoveryProvider(PreflightConfigService preflightConfigService, NodeService<DataNodeDto> nodeService) {
        this.preflightConfigService = preflightConfigService;
        this.nodeService = nodeService;
        this.resultsCachingSupplier = Suppliers.memoize(this::doGet);
    }

    public Boolean get() {
        return this.resultsCachingSupplier.get();
    }

    private Boolean doGet() {
        List<URI> discovered;
        PreflightConfigResult preflightResult = this.preflightConfigService.getPreflightConfigResult();
        if (preflightResult == PreflightConfigResult.FINISHED && !(discovered = this.discover()).isEmpty()) {
            LOG.debug("Running with DataNode(s).");
            return Boolean.TRUE;
        }
        LOG.debug("Not running with DataNode(s).");
        return Boolean.FALSE;
    }

    private List<URI> discover() {
        return this.nodeService.allActive().values().stream().map(Node::getTransportAddress).map(URI::create).collect(Collectors.toList());
    }
}

