/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import jakarta.inject.Inject;
import org.bson.conversions.Bson;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.grok.GrokPattern;
import org.graylog2.search.SearchQuery;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class PaginatedGrokPatternService
extends PaginatedDbService<GrokPattern> {
    private static final String COLLECTION_NAME = "grok_patterns";

    @Inject
    public PaginatedGrokPatternService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, GrokPattern.class, COLLECTION_NAME);
    }

    public long count() {
        return this.db.count();
    }

    public PaginatedList<GrokPattern> findPaginated(SearchQuery searchQuery, int page, int perPage, String sortField, String order) {
        DBQuery.Query dbQuery = searchQuery.toDBQuery();
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort((Bson)dbQuery, (Bson)sortBuilder, page, perPage);
    }
}

