/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import org.graylog2.inputs.WithInputConfiguration;
import org.graylog2.inputs.encryption.EncryptedInputConfigs;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.security.encryption.EncryptedValue;

public class InputConfigurationDeserializer
extends BeanDeserializer {
    private final BeanDeserializer deserializer;
    private final InputFieldConfigProvider inputFieldConfigProvider;

    public InputConfigurationDeserializer(BeanDeserializer deserializer, InputFieldConfigProvider inputFieldConfigProvider) {
        super((BeanDeserializerBase)deserializer);
        this.deserializer = deserializer;
        this.inputFieldConfigProvider = inputFieldConfigProvider;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object value = this.deserializer.deserialize(p, ctxt);
        if (value instanceof WithInputConfiguration) {
            WithInputConfiguration valueWithConfiguration = (WithInputConfiguration)value;
            Set<String> encryptedFields = this.getEncryptedFields(valueWithConfiguration.type());
            if (encryptedFields.isEmpty()) {
                return value;
            }
            ObjectMapper objectMapper = (ObjectMapper)p.getCodec();
            HashMap<String, Object> configuration = new HashMap<String, Object>(valueWithConfiguration.configuration());
            encryptedFields.forEach(field -> {
                if (configuration.containsKey(field)) {
                    EncryptedValue encryptedValue = (EncryptedValue)objectMapper.convertValue(configuration.get(field), EncryptedValue.class);
                    configuration.put((String)field, encryptedValue);
                }
            });
            return valueWithConfiguration.withConfiguration(configuration);
        }
        return value;
    }

    private Set<String> getEncryptedFields(String type) {
        return this.inputFieldConfigProvider.getConfig(type).map(EncryptedInputConfigs::getEncryptedFields).orElse(Set.of());
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        this.deserializer.resolve(ctxt);
    }

    public static interface InputFieldConfigProvider {
        public Optional<MessageInput.Config> getConfig(String var1);
    }
}

