/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.UpdateResult;
import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20180718155800_AddContentPackIdAndRev
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20180718155800_AddContentPackIdAndRev.class);
    private final MongoCollection<Document> collection;

    @Inject
    public V20180718155800_AddContentPackIdAndRev(MongoConnection mongoConnection) {
        this((MongoCollection<Document>)mongoConnection.getMongoDatabase().getCollection("content_packs"));
    }

    private V20180718155800_AddContentPackIdAndRev(MongoCollection<Document> collection) {
        this.collection = collection;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2018-07-18T15:58:00Z");
    }

    @Override
    public void upgrade() {
        FindIterable documentsWithMissingFields = this.collection.find(Filters.or((Bson[])new Bson[]{Filters.not((Bson)Filters.exists((String)"id")), Filters.not((Bson)Filters.exists((String)"rev"))}));
        for (Document document : documentsWithMissingFields) {
            ObjectId objectId = document.getObjectId((Object)"_id");
            LOG.debug("Found document with missing \"id\" or \"rev\" field with ID <{}>", (Object)objectId);
            String id = (String)document.get((Object)"id", (Object)objectId.toHexString());
            int rev = (Integer)document.get((Object)"rev", (Object)0);
            document.put("id", (Object)id);
            document.put("rev", (Object)rev);
            UpdateResult updateResult = this.collection.replaceOne(Filters.eq((String)"_id", (Object)objectId), (Object)document);
            if (updateResult.wasAcknowledged()) {
                LOG.debug("Successfully updated document with ID <{}>", (Object)objectId);
                continue;
            }
            LOG.error("Failed to update document with ID <{}>", (Object)objectId);
        }
    }
}

