/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import jakarta.inject.Inject;
import java.time.ZonedDateTime;
import org.graylog2.configuration.IndexSetsDefaultConfiguration;
import org.graylog2.configuration.IndexSetsDefaultConfigurationFactory;
import org.graylog2.datatiering.fallback.PlaceholderDataTieringConfig;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V202211021200_CreateDefaultIndexDefaultsConfig
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V202211021200_CreateDefaultIndexDefaultsConfig.class);
    private final ClusterConfigService clusterConfigService;
    private final IndexSetsDefaultConfigurationFactory factory;

    @Inject
    public V202211021200_CreateDefaultIndexDefaultsConfig(ClusterConfigService clusterConfigService, IndexSetsDefaultConfigurationFactory factory) {
        this.clusterConfigService = clusterConfigService;
        this.factory = factory;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2022-11-02T12:00:00Z");
    }

    @Override
    public void upgrade() {
        IndexSetsDefaultConfiguration indexSetsDefaultConfiguration = this.clusterConfigService.get(IndexSetsDefaultConfiguration.class);
        if (indexSetsDefaultConfiguration == null) {
            indexSetsDefaultConfiguration = this.factory.create();
        } else if (indexSetsDefaultConfiguration.dataTiering() instanceof PlaceholderDataTieringConfig) {
            LOG.info("Applying data tiering to Indexset defaults");
            indexSetsDefaultConfiguration = this.factory.addDataTieringDefaults(indexSetsDefaultConfiguration);
        } else {
            LOG.debug("Migration already completed.");
            return;
        }
        try {
            this.clusterConfigService.write(indexSetsDefaultConfiguration);
            LOG.debug("IndexSetsDefaultConfiguration saved.");
        }
        catch (Exception e) {
            LOG.error("Unable to write IndexSetsDefaultConfiguration.", (Throwable)e);
        }
    }
}

