/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.UUID;
import javax.annotation.Nullable;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.shared.SuppressForbidden;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;

public final class Tools {
    private static final byte[] EMPTY_BYTE_ARRAY_4 = new byte[]{0, 0, 0, 0};
    private static final byte[] EMPTY_BYTE_ARRAY_16 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String ES_DATE_FORMAT_JODA = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String ES_DATE_FORMAT_NO_MS = "yyyy-MM-dd HH:mm:ss";
    public static final DateTimeFormatter ES_DATE_FORMAT_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC();
    public static final DateTimeFormatter ES_DATE_FORMAT_NO_MS_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss").withZoneUTC();
    public static final DateTimeFormatter ISO_DATE_FORMAT_FORMATTER = ISODateTimeFormat.dateTime().withZoneUTC();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final int AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();

    private Tools() {
    }

    public static String getPID() {
        return ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    }

    public static String syslogLevelToReadable(int level) {
        switch (level) {
            case 0: {
                return "Emergency";
            }
            case 1: {
                return "Alert";
            }
            case 2: {
                return "Critical";
            }
            case 3: {
                return "Error";
            }
            case 4: {
                return "Warning";
            }
            case 5: {
                return "Notice";
            }
            case 6: {
                return "Informational";
            }
            case 7: {
                return "Debug";
            }
        }
        return "Invalid";
    }

    public static String syslogFacilityToReadable(int facility) {
        switch (facility) {
            case 0: {
                return "kernel";
            }
            case 1: {
                return "user-level";
            }
            case 2: {
                return "mail";
            }
            case 3: {
                return "system daemon";
            }
            case 4: 
            case 10: {
                return "security/authorization";
            }
            case 5: {
                return "syslogd";
            }
            case 6: {
                return "line printer";
            }
            case 7: {
                return "network news";
            }
            case 8: {
                return "UUCP";
            }
            case 9: 
            case 15: {
                return "clock";
            }
            case 11: {
                return "FTP";
            }
            case 12: {
                return "NTP";
            }
            case 13: {
                return "log audit";
            }
            case 14: {
                return "log alert";
            }
            case 16: {
                return "local0";
            }
            case 17: {
                return "local1";
            }
            case 18: {
                return "local2";
            }
            case 19: {
                return "local3";
            }
            case 20: {
                return "local4";
            }
            case 21: {
                return "local5";
            }
            case 22: {
                return "local6";
            }
            case 23: {
                return "local7";
            }
        }
        return "Unknown";
    }

    public static String getSystemInformation() {
        Object ret = System.getProperty("java.vendor");
        ret = (String)ret + " " + System.getProperty("java.version");
        ret = (String)ret + " on " + System.getProperty("os.name");
        ret = (String)ret + " " + System.getProperty("os.version");
        return ret;
    }

    public static String decompressZlib(byte[] compressedData) throws IOException {
        return Tools.decompressZlib(compressedData, Long.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    public static String decompressZlib(byte[] compressedData, long maxBytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String decompressGzip(byte[] compressedData) throws IOException {
        return Tools.decompressGzip(compressedData, Long.MAX_VALUE);
    }

    /*
     * Exception decompiling
     */
    public static String decompressGzip(byte[] compressedData, long maxBytes) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getUTCTimestamp() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static double getUTCTimestampWithMilliseconds() {
        return Tools.getUTCTimestampWithMilliseconds(System.currentTimeMillis());
    }

    public static double getUTCTimestampWithMilliseconds(long timestamp) {
        return (double)timestamp / 1000.0;
    }

    @SuppressForbidden(value="Deliberate invocation")
    public static String getLocalHostname() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            return "Unknown";
        }
        return addr.getHostName();
    }

    @SuppressForbidden(value="Deliberate invocation")
    public static String getLocalCanonicalHostname() {
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex) {
            return "Unknown";
        }
        return addr.getCanonicalHostName();
    }

    public static int getTimestampDaysAgo(int ts, int days) {
        return ts - days * 86400;
    }

    public static String encodeBase64(String what) {
        return BaseEncoding.base64().encode(what.getBytes(StandardCharsets.UTF_8));
    }

    public static String decodeBase64(String what) {
        return new String(BaseEncoding.base64().decode((CharSequence)what), StandardCharsets.UTF_8);
    }

    @SuppressForbidden(value="Deliberate invocation")
    public static String rdnsLookup(InetAddress socketAddress) throws UnknownHostException {
        return socketAddress.getCanonicalHostName();
    }

    public static String generateServerId() {
        return UUID.randomUUID().toString();
    }

    public static <T extends Comparable<? super T>> SortedSet<T> asSortedSet(Collection<T> c) {
        return ImmutableSortedSet.copyOf(c);
    }

    public static String buildElasticSearchTimeFormat(DateTime timestamp) {
        return timestamp.toString(ES_DATE_FORMAT_FORMATTER);
    }

    public static DateTime dateTimeFromDouble(double x) {
        return new DateTime(Math.round(x * 1000.0), DateTimeZone.UTC);
    }

    public static DateTime dateTimeFromString(String s) {
        return ISO_DATE_FORMAT_FORMATTER.parseDateTime(s);
    }

    public static DateTimeFormatter timeFormatterWithOptionalMilliseconds() {
        DateTimeParser ms = new DateTimeFormatterBuilder().appendLiteral(".").appendFractionOfSecond(1, 3).toParser();
        return new DateTimeFormatterBuilder().append(DateTimeFormat.forPattern((String)ES_DATE_FORMAT_NO_MS).withZoneUTC()).appendOptional(ms).toFormatter();
    }

    public static DateTime nowUTC() {
        return new DateTime(DateTimeZone.UTC);
    }

    public static DateTime now(DateTimeZone dateTimeZone) {
        return new DateTime(dateTimeZone);
    }

    @Deprecated
    public static DateTime iso8601() {
        return Tools.nowUTC();
    }

    public static String getISO8601String(DateTime time) {
        return ISODateTimeFormat.dateTime().print((ReadableInstant)time);
    }

    public static String elasticSearchTimeFormatToISO8601(String time) {
        try {
            DateTime dt = DateTime.parse((String)time, (DateTimeFormatter)ES_DATE_FORMAT_FORMATTER);
            return Tools.getISO8601String(dt);
        }
        catch (IllegalArgumentException e) {
            return time;
        }
    }

    public static String safeSubstring(String target, int start, int end) {
        if (target == null) {
            return null;
        }
        int slen = target.length();
        if (start < 0 || end <= 0 || end <= start || slen < start || slen < end) {
            return null;
        }
        return target.substring(start, end);
    }

    public static Double getDouble(Object x) {
        String s;
        if (x == null) {
            return null;
        }
        if (x instanceof Double) {
            return (Double)x;
        }
        if (x instanceof String && ((s = x.toString()) == null || s.isEmpty())) {
            return null;
        }
        return Doubles.tryParse((String)x.toString());
    }

    public static Number getNumber(Object o, Number defaultValue) {
        if (o instanceof Number) {
            return (Number)o;
        }
        try {
            return Double.valueOf(String.valueOf(o));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static InetAddress guessPrimaryNetworkAddress(boolean preferIPv4) throws SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        if (interfaces != null) {
            for (NetworkInterface interf : Collections.list(interfaces)) {
                if (interf.isLoopback() || !interf.isUp()) continue;
                for (InetAddress addr : Collections.list(interf.getInetAddresses())) {
                    if (preferIPv4 && addr instanceof Inet4Address) {
                        return addr;
                    }
                    if (preferIPv4 || !(addr instanceof Inet6Address)) continue;
                    return addr;
                }
            }
        }
        return InetAddress.getLoopbackAddress();
    }

    public static boolean isWildcardInetAddress(@Nullable InetAddress inetAddress) {
        return inetAddress != null && (Arrays.equals(EMPTY_BYTE_ARRAY_4, inetAddress.getAddress()) || Arrays.equals(EMPTY_BYTE_ARRAY_16, inetAddress.getAddress()));
    }

    @Nullable
    public static URI getUriWithPort(@Nullable URI uri, int port) {
        if (uri == null) {
            return null;
        }
        try {
            if (uri.getPort() == -1) {
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), switch (uri.getScheme()) {
                    case "http" -> 80;
                    case "https" -> 443;
                    default -> port;
                }, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not parse URI.", e);
        }
    }

    @Nullable
    public static URI getUriWithScheme(@Nullable URI uri, String scheme) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(scheme, uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not parse URI.", e);
        }
    }

    @Nullable
    public static URI getUriWithDefaultPath(@Nullable URI uri, String path) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), Strings.isNullOrEmpty((String)uri.getPath()) ? path : uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not parse URI.", e);
        }
    }

    @Nullable
    public static URI uriWithTrailingSlash(@Nullable URI uri) {
        if (uri == null) {
            return null;
        }
        String path = (String)MoreObjects.firstNonNull((Object)uri.getPath(), (Object)"/");
        if (path.endsWith("/")) {
            return uri;
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path + "/", uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not parse URI.", e);
        }
    }

    @Nullable
    public static URI normalizeURI(@Nullable URI uri, String scheme, int port, String path) {
        return Optional.ofNullable(uri).map(u -> Tools.getUriWithScheme(u, scheme)).map(u -> Tools.getUriWithPort(u, port)).map(u -> Tools.getUriWithDefaultPath(u, path)).map(Tools::uriWithTrailingSlash).map(URI::normalize).orElse(null);
    }

    @Nullable
    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String bytesToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format(Locale.ENGLISH, "%02x", b & 0xFF)).append(' ');
        }
        return sb.toString().trim();
    }

    public static void silenceUncaughtExceptionsInThisThread() {
        Thread.currentThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread ignored, Throwable ignored1) {
            }
        });
    }

    public static Optional<AbsoluteRange> extractHistogramBoundaries(String query) {
        try {
            JsonParser jp = OBJECT_MAPPER.getFactory().createParser(query);
            JsonNode rootNode = (JsonNode)OBJECT_MAPPER.readTree(jp);
            if (rootNode == null) {
                throw new IOException("null result");
            }
            JsonNode timestampNode = rootNode.findValue("range").findValue("timestamp");
            String from = Tools.elasticSearchTimeFormatToISO8601(timestampNode.findValue("from").asText());
            String to = Tools.elasticSearchTimeFormatToISO8601(timestampNode.findValue("to").asText());
            return Optional.of(AbsoluteRange.create(from, to));
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    public static int availableProcessors() {
        return AVAILABLE_PROCESSORS;
    }

    public static class LogUncaughtExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final Logger log;

        public LogUncaughtExceptionHandler(Logger log) {
            this.log = log;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.log.error("Thread {} failed by not catching exception: {}.", (Object)t.getName(), (Object)e);
        }
    }
}

