/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.shared.rest.resources.RestResource;
import org.graylog2.system.traffic.TrafficCounterService;
import org.joda.time.Duration;

@Api(value="System/ClusterTraffic", description="Cluster traffic stats", tags={"cloud"})
@RequiresAuthentication
@Path(value="/system/cluster/traffic")
@Produces(value={"application/json"})
public class TrafficResource
extends RestResource {
    private final TrafficCounterService trafficCounterService;

    @Inject
    public TrafficResource(TrafficCounterService trafficCounterService) {
        this.trafficCounterService = trafficCounterService;
    }

    @GET
    @ApiOperation(value="Get the cluster traffic stats")
    public TrafficCounterService.TrafficHistogram get(@ApiParam(name="days", value="For how many days the traffic stats should be returned") @QueryParam(value="days") @DefaultValue(value="30") int days, @ApiParam(name="daily", value="Whether the traffic should be aggregate to daily values") @QueryParam(value="daily") @DefaultValue(value="false") boolean daily, @ApiParam(name="includeToday", value="Whether the traffic should include up to the current date/time (in UTC).") @QueryParam(value="includeToday") @DefaultValue(value="true") boolean includeToday) {
        return this.trafficCounterService.clusterTrafficOfLastDays(Duration.standardDays((long)days), daily ? TrafficCounterService.Interval.DAILY : TrafficCounterService.Interval.HOURLY, includeToday);
    }
}

