/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.tools;

import com.codahale.metrics.annotation.Timed;
import jakarta.inject.Inject;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.lookup.LookupResult;
import org.graylog2.rest.models.tools.requests.LookupTableTestRequest;
import org.graylog2.rest.resources.tools.responses.LookupTableTesterResponse;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/tools/lookup_table_tester")
@Produces(value={"application/json"})
public class LookupTableTesterResource
extends RestResource {
    private final LookupTableService lookupTableService;

    @Inject
    public LookupTableTesterResource(LookupTableService lookupTableService) {
        this.lookupTableService = lookupTableService;
    }

    @GET
    @Timed
    public LookupTableTesterResponse grokTest(@QueryParam(value="lookup_table_name") @NotEmpty String lookupTableName, @QueryParam(value="string") @NotEmpty String string) {
        return this.doTestLookupTable(string, lookupTableName);
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NoAuditEvent(value="only used to test lookup tables")
    @RequiresPermissions(value={"lookuptables:read"})
    public LookupTableTesterResponse testLookupTable(@Valid @NotNull LookupTableTestRequest lookupTableTestRequest) {
        return this.doTestLookupTable(lookupTableTestRequest.string(), lookupTableTestRequest.lookupTableName());
    }

    private LookupTableTesterResponse doTestLookupTable(String string, String lookupTableName) {
        if (!this.lookupTableService.hasTable(lookupTableName)) {
            return LookupTableTesterResponse.error("Lookup table <" + lookupTableName + "> doesn't exist");
        }
        LookupTableService.Function table = this.lookupTableService.newBuilder().lookupTable(lookupTableName).build();
        LookupResult result = table.lookup(string.trim());
        if (result == null) {
            return LookupTableTesterResponse.emptyResult(string);
        }
        return LookupTableTesterResponse.result(string, result);
    }
}

