/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.search;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.bson.types.ObjectId;
import org.graylog2.utilities.date.MultiFormatDateParser;

public class SearchQueryField {
    private static final MultiFormatDateParser dateParser = new MultiFormatDateParser();
    private final String dbField;
    private final Type fieldType;

    public static SearchQueryField create(String dbField) {
        return new SearchQueryField(dbField, Type.STRING);
    }

    public static SearchQueryField create(String dbField, Type fieldType) {
        return new SearchQueryField(dbField, fieldType != null ? fieldType : Type.STRING);
    }

    SearchQueryField(String dbField, Type fieldType) {
        this.dbField = dbField;
        this.fieldType = fieldType;
    }

    public String getDbField() {
        return this.dbField;
    }

    public Type getFieldType() {
        return this.fieldType;
    }

    public static enum Type {
        STRING(value -> value),
        DATE(value -> dateParser.parseDate((String)value)),
        INT(value -> Integer.parseInt(value)),
        LONG(value -> Long.parseLong(value)),
        OBJECT_ID(value -> new ObjectId(value)),
        BOOLEAN(value -> Boolean.parseBoolean(value));

        public static final Collection<Type> NUMERIC_TYPES;
        private final Function<String, Object> mongoValueConverter;

        private Type(Function<String, Object> mongoValueConverter) {
            this.mongoValueConverter = mongoValueConverter;
        }

        public Function<String, Object> getMongoValueConverter() {
            return this.mongoValueConverter;
        }

        static {
            NUMERIC_TYPES = List.of(DATE, LONG, INT);
        }
    }
}

