/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.telemetry.cluster;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.graylog2.cluster.ClusterConfig;
import org.graylog2.cluster.leader.LeaderElectionService;
import org.graylog2.plugin.ServerStatus;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.graylog2.plugin.cluster.ClusterId;
import org.graylog2.shared.ServerVersion;
import org.graylog2.telemetry.cluster.db.DBTelemetryClusterInfo;
import org.joda.time.DateTime;

public class TelemetryClusterService {
    public static final String UNKNOWN = "unknown";
    private final ServerStatus serverStatus;
    private final String clusterId;
    private final ClusterConfigService clusterConfigService;
    private final LeaderElectionService leaderElectionService;
    private final DBTelemetryClusterInfo dbTelemetryClusterInfo;

    @Inject
    public TelemetryClusterService(ServerStatus serverStatus, ClusterConfigService clusterConfigService, LeaderElectionService leaderElectionService, DBTelemetryClusterInfo dbTelemetryClusterInfo) {
        this.serverStatus = serverStatus;
        this.clusterId = Optional.ofNullable(clusterConfigService.get(ClusterId.class)).map(ClusterId::clusterId).orElse(UNKNOWN);
        this.clusterConfigService = clusterConfigService;
        this.leaderElectionService = leaderElectionService;
        this.dbTelemetryClusterInfo = dbTelemetryClusterInfo;
    }

    public void updateTelemetryClusterData() {
        ImmutableMap nodeInfo = new ImmutableMap.Builder().put((Object)"facility", (Object)"graylog-server").put((Object)"codename", (Object)"Noir").put((Object)"node_id", (Object)this.serverStatus.getNodeId().toString()).put((Object)"cluster_id", (Object)this.clusterId).put((Object)"version", (Object)ServerVersion.VERSION.toString()).put((Object)"started_at", (Object)Tools.getISO8601String(this.serverStatus.getStartedAt())).put((Object)"hostname", (Object)Tools.getLocalCanonicalHostname()).put((Object)"lifecycle", (Object)this.serverStatus.getLifecycle().getDescription().toLowerCase(Locale.ENGLISH)).put((Object)"lb_status", (Object)this.serverStatus.getLifecycle().getLoadbalancerStatus().toString().toLowerCase(Locale.ENGLISH)).put((Object)"timezone", (Object)this.serverStatus.getTimezone().getID()).put((Object)"operating_system", (Object)(System.getProperty("os.name", UNKNOWN) + " " + System.getProperty("os.version", UNKNOWN))).put((Object)"is_leader", (Object)this.leaderElectionService.isLeader()).put((Object)"is_processing", (Object)this.serverStatus.isProcessing()).build();
        this.dbTelemetryClusterInfo.update((Map<String, Object>)nodeInfo, this.serverStatus.getNodeId().toString());
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public Optional<DateTime> getClusterCreationDate() {
        return Optional.ofNullable(this.clusterConfigService.getRaw(ClusterId.class)).map(ClusterConfig::lastUpdated);
    }

    public Map<String, Map<String, Object>> nodesTelemetryInfo() {
        return this.dbTelemetryClusterInfo.findAll();
    }
}

