/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graylog2.shared.bindings.providers.ObjectMapperProvider;
import org.graylog2.shared.rest.documentation.generator.Generator;

public class GenerateApiDefinition {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private static void log(String s) {
        System.out.println(s);
    }

    private static void bail(String s) {
        GenerateApiDefinition.log(s);
        System.exit(-1);
    }

    private static Set<Class<?>> findResources(String[] controllerPackages) {
        ImmutableSet.Builder resources = ImmutableSet.builder();
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().acceptPackages(controllerPackages);
        try (ScanResult scanResult = classGraph.scan();){
            for (ClassInfo classInfo : scanResult.getClassesWithAnnotation("jakarta.ws.rs.Path")) {
                resources.add((Object)classInfo.loadClass());
            }
        }
        return resources.build();
    }

    private static boolean deleteDirectory(File directoryToBeDeleted) {
        File[] allContents = directoryToBeDeleted.listFiles();
        if (allContents != null) {
            for (File file : allContents) {
                GenerateApiDefinition.deleteDirectory(file);
            }
        }
        return directoryToBeDeleted.delete();
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            GenerateApiDefinition.bail("Syntax: " + GenerateApiDefinition.class.getSimpleName() + " <outdir> <package1> ... <packageN>");
        }
        String targetName = args[0];
        Path targetPath = Paths.get(targetName, new String[0]);
        GenerateApiDefinition.deleteDirectory(targetPath.toFile());
        Files.createDirectories(targetPath, new FileAttribute[0]);
        GenerateApiDefinition.log("Generating Swagger definition for API ...");
        String[] packageNames = (String[])Arrays.stream(args).skip(1L).toArray(String[]::new);
        Set<Class<?>> resourceClasses = GenerateApiDefinition.findResources(packageNames);
        ObjectMapper objectMapper = new ObjectMapperProvider().get();
        Generator generator = new Generator(resourceClasses, Collections.emptyMap(), "/plugins", objectMapper, false);
        Map<String, Object> overview = generator.generateOverview();
        GenerateApiDefinition.writeJsonToFile(targetName + "/api.json", overview);
        List<Map<String, Object>> apis = GenerateApiDefinition.retrieveApis(overview);
        apis.forEach(api -> {
            String path = GenerateApiDefinition.pathFromApi(api);
            try {
                GenerateApiDefinition.log("Writing " + path);
                Map<String, Object> apiResponse = generator.generateForRoute(path, "/");
                GenerateApiDefinition.writeJsonToFile(targetName + path + ".json", apiResponse);
            }
            catch (IOException e) {
                GenerateApiDefinition.log("Unable to write " + targetName + path + ":" + e);
            }
        });
        GenerateApiDefinition.log("Done.");
    }

    private static String pathFromApi(Map<String, Object> api) {
        return (String)api.get("path");
    }

    private static List<Map<String, Object>> retrieveApis(Map<String, Object> overview) {
        return overview.containsKey("apis") ? (List)overview.get("apis") : Collections.emptyList();
    }

    private static void writeJsonToFile(String filename, Object content) throws IOException {
        File file = new File(filename);
        file.getParentFile().mkdirs();
        if (!file.createNewFile()) {
            throw new RuntimeException("Unable to create file " + file.getAbsolutePath());
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        objectMapper.writeValue((OutputStream)outputStream, content);
    }
}

