/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.GetCallerIdentityRequest;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.graylog.aws.config.AWSPluginConfiguration;
import org.graylog2.Configuration;
import org.graylog2.shared.utilities.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AWSAuthProvider
implements AWSCredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(AWSAuthProvider.class);
    private final Configuration configuration;
    private final AWSCredentialsProvider credentials;

    public AWSAuthProvider(Configuration configuration, AWSPluginConfiguration awsConfig) {
        this(configuration, awsConfig, null, null, null, null);
    }

    public AWSAuthProvider(Configuration configuration, AWSPluginConfiguration awsConfig, @Nullable String accessKey, @Nullable String secretKey, @Nullable String region, @Nullable String assumeRoleArn) {
        this.configuration = configuration;
        this.credentials = this.resolveAuthentication(awsConfig, accessKey, secretKey, region, assumeRoleArn);
    }

    private AWSCredentialsProvider resolveAuthentication(AWSPluginConfiguration config, @Nullable String accessKey, @Nullable String secretKey, @Nullable String region, @Nullable String assumeRoleArn) {
        AWSCredentialsProvider awsCredentials;
        AWSCredentialsProvider aWSCredentialsProvider = awsCredentials = this.configuration.isCloud() ? this.getCloudAwsCredentialsProvider(accessKey, secretKey) : this.getStdAwsCredentialsProvider(config, accessKey, secretKey);
        if (!Strings.isNullOrEmpty((String)assumeRoleArn) && !Strings.isNullOrEmpty((String)region)) {
            LOG.debug("Creating cross account assume role credentials");
            return this.getSTSCredentialsProvider(awsCredentials, region, assumeRoleArn);
        }
        return awsCredentials;
    }

    private AWSCredentialsProvider getStdAwsCredentialsProvider(AWSPluginConfiguration config, String accessKey, String secretKey) {
        DefaultAWSCredentialsProviderChain awsCredentials;
        if (!Strings.isNullOrEmpty((String)accessKey) && !Strings.isNullOrEmpty((String)secretKey)) {
            awsCredentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
            LOG.debug("Using input specific config");
        } else if (!Strings.isNullOrEmpty((String)config.accessKey()) && !Strings.isNullOrEmpty((String)config.secretKey(this.configuration.getPasswordSecret()))) {
            awsCredentials = new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(config.accessKey(), config.secretKey(this.configuration.getPasswordSecret())));
            LOG.debug("Using AWS Plugin config");
        } else {
            awsCredentials = new DefaultAWSCredentialsProviderChain();
            LOG.debug("Using Default Provider Chain");
        }
        return awsCredentials;
    }

    private AWSCredentialsProvider getCloudAwsCredentialsProvider(String accessKey, String secretKey) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)accessKey), (Object)"Access key is required.");
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)secretKey), (Object)"Secret key is required.");
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey));
    }

    private AWSCredentialsProvider getSTSCredentialsProvider(AWSCredentialsProvider awsCredentials, String region, String assumeRoleArn) {
        AWSSecurityTokenService stsClient = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(region)).withCredentials(awsCredentials)).build();
        String roleSessionName = StringUtils.f("API_KEY_%s@ACCOUNT_%s", awsCredentials.getCredentials().getAWSAccessKeyId(), stsClient.getCallerIdentity(new GetCallerIdentityRequest()).getAccount());
        LOG.debug("Cross account role session name: " + roleSessionName);
        return new STSAssumeRoleSessionCredentialsProvider.Builder(assumeRoleArn, roleSessionName).withStsClient(stsClient).build();
    }

    public AWSCredentials getCredentials() {
        return this.credentials.getCredentials();
    }

    public void refresh() {
        this.credentials.refresh();
    }
}

