/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.aws.config;

import com.amazonaws.regions.Regions;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.aws.config.AutoValue_AWSPluginConfiguration;
import org.graylog2.security.AESTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect
@AutoValue
public abstract class AWSPluginConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AWSPluginConfiguration.class);

    @JsonProperty(value="lookups_enabled")
    public abstract boolean lookupsEnabled();

    @JsonProperty(value="lookup_regions")
    public abstract String lookupRegions();

    @JsonProperty(value="access_key")
    public abstract String accessKey();

    @JsonProperty(value="secret_key")
    @Nullable
    public abstract String encryptedSecretKey();

    public String secretKey(String encryptionKey) {
        if (Strings.isNullOrEmpty((String)this.encryptedSecretKey())) {
            return this.encryptedSecretKey();
        }
        return AESTools.decrypt(this.encryptedSecretKey(), encryptionKey, this.secretKeySalt());
    }

    @JsonProperty(value="secret_key_salt")
    @Nullable
    public abstract String secretKeySalt();

    @JsonProperty(value="proxy_enabled")
    public abstract boolean proxyEnabled();

    @JsonCreator
    public static AWSPluginConfiguration create(@JsonProperty(value="lookups_enabled") boolean lookupsEnabled, @JsonProperty(value="lookup_regions") String lookupRegions, @JsonProperty(value="access_key") String accessKey, @JsonProperty(value="secret_key") @Nullable String secretKey, @JsonProperty(value="secret_key_salt") @Nullable String secretKeySalt, @JsonProperty(value="proxy_enabled") boolean proxyEnabled) {
        return AWSPluginConfiguration.builder().lookupsEnabled(lookupsEnabled).lookupRegions(lookupRegions).accessKey(accessKey).encryptedSecretKey(secretKey).secretKeySalt(secretKeySalt).proxyEnabled(proxyEnabled).build();
    }

    public static AWSPluginConfiguration createDefault() {
        return AWSPluginConfiguration.builder().lookupsEnabled(false).lookupRegions("").accessKey("").encryptedSecretKey(null).secretKeySalt(null).proxyEnabled(false).build();
    }

    static Builder builder() {
        return new AutoValue_AWSPluginConfiguration.Builder();
    }

    @JsonIgnore
    public List<Regions> getLookupRegions() {
        String[] regions;
        if (this.lookupRegions() == null || this.lookupRegions().isEmpty()) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String regionName : regions = this.lookupRegions().split(",")) {
            try {
                builder.add((Object)Regions.fromName((String)regionName.trim()));
            }
            catch (IllegalArgumentException e) {
                LOG.info("Cannot translate [{}] into AWS region. Make sure it is a correct region code like for example 'us-west-1'.", (Object)regionName);
            }
        }
        return builder.build();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder lookupsEnabled(boolean var1);

        public abstract Builder lookupRegions(String var1);

        public abstract Builder accessKey(String var1);

        abstract Builder encryptedSecretKey(String var1);

        public Builder secretKey(String secretKey, String encryptionKey) {
            String salt = AESTools.generateNewSalt();
            return this.encryptedSecretKey(AESTools.encrypt(secretKey, encryptionKey, salt)).secretKeySalt(salt);
        }

        abstract Builder secretKeySalt(String var1);

        public abstract Builder proxyEnabled(boolean var1);

        public abstract AWSPluginConfiguration build();
    }
}

