/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.facade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.events.contentpack.entities.EventDefinitionEntity;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventDefinitionHandler;
import org.graylog.scheduler.DBJobDefinitionService;
import org.graylog.scheduler.JobDefinitionDto;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.facades.EntityFacade;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.constraints.Constraint;
import org.graylog2.contentpacks.model.constraints.PluginVersionConstraint;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityExcerpt;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.NativeEntity;
import org.graylog2.contentpacks.model.entities.NativeEntityDescriptor;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.database.users.User;
import org.graylog2.shared.users.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDefinitionFacade
implements EntityFacade<EventDefinitionDto> {
    private static final Logger LOG = LoggerFactory.getLogger(EventDefinitionFacade.class);
    private final ObjectMapper objectMapper;
    private final EventDefinitionHandler eventDefinitionHandler;
    private final DBJobDefinitionService jobDefinitionService;
    private final DBEventDefinitionService eventDefinitionService;
    private final Set<PluginMetaData> pluginMetaData;
    private final UserService userService;

    @Inject
    public EventDefinitionFacade(ObjectMapper objectMapper, EventDefinitionHandler eventDefinitionHandler, Set<PluginMetaData> pluginMetaData, DBJobDefinitionService jobDefinitionService, DBEventDefinitionService eventDefinitionService, UserService userService) {
        this.objectMapper = objectMapper;
        this.pluginMetaData = pluginMetaData;
        this.eventDefinitionHandler = eventDefinitionHandler;
        this.jobDefinitionService = jobDefinitionService;
        this.eventDefinitionService = eventDefinitionService;
        this.userService = userService;
    }

    @VisibleForTesting
    private Entity exportNativeEntity(EventDefinitionDto eventDefinition, EntityDescriptorIds entityDescriptorIds) {
        Optional<JobDefinitionDto> jobDefinition = this.jobDefinitionService.getByConfigField("event_definition_id", eventDefinition.id());
        EventDefinitionEntity entity = eventDefinition.toContentPackEntity(entityDescriptorIds).toBuilder().isScheduled(ValueReference.of(jobDefinition.isPresent())).build();
        JsonNode data = (JsonNode)this.objectMapper.convertValue((Object)entity, JsonNode.class);
        return ((EntityV1.Builder)((EntityV1.Builder)EntityV1.builder().id(ModelId.of(entityDescriptorIds.getOrThrow(eventDefinition.id(), ModelTypes.EVENT_DEFINITION_V1)))).type(ModelTypes.EVENT_DEFINITION_V1)).constraints(this.versionConstraints(eventDefinition)).data(data).build();
    }

    @Override
    public Optional<Entity> exportEntity(EntityDescriptor entityDescriptor, EntityDescriptorIds entityDescriptorIds) {
        ModelId modelId = entityDescriptor.id();
        Optional<EventDefinitionDto> eventDefinition = this.eventDefinitionService.get(modelId.id());
        if (!eventDefinition.isPresent()) {
            LOG.debug("Couldn't find event definition {}", (Object)entityDescriptor);
            return Optional.empty();
        }
        return Optional.of(this.exportNativeEntity(eventDefinition.get(), entityDescriptorIds));
    }

    private ImmutableSet<Constraint> versionConstraints(EventDefinitionDto eventDefinitionDto) {
        String packageName = eventDefinitionDto.config().getContentPackPluginPackage();
        return (ImmutableSet)this.pluginMetaData.stream().filter(metaData -> packageName.equals(metaData.getClass().getCanonicalName())).map(PluginVersionConstraint::of).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public NativeEntity<EventDefinitionDto> createNativeEntity(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, String username) {
        if (entity instanceof EntityV1) {
            User user = Optional.ofNullable(this.userService.load(username)).orElseThrow(() -> new IllegalStateException("Cannot load user <" + username + "> from db"));
            return this.decode((EntityV1)entity, parameters, nativeEntities, user);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private NativeEntity<EventDefinitionDto> decode(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities, User user) {
        EventDefinitionEntity eventDefinitionEntity = (EventDefinitionEntity)this.objectMapper.convertValue((Object)entity.data(), EventDefinitionEntity.class);
        Object eventDefinition = eventDefinitionEntity.toNativeEntity((Map)parameters, (Map)nativeEntities);
        EventDefinitionDto savedDto = eventDefinitionEntity.isScheduled().asBoolean(parameters) != false ? this.eventDefinitionHandler.create((EventDefinitionDto)eventDefinition, Optional.ofNullable(user)) : this.eventDefinitionHandler.createWithoutSchedule((EventDefinitionDto)eventDefinition, Optional.ofNullable(user));
        return NativeEntity.create(entity.id(), savedDto.id(), ModelTypes.EVENT_DEFINITION_V1, savedDto.title(), savedDto);
    }

    @Override
    public Optional<NativeEntity<EventDefinitionDto>> loadNativeEntity(NativeEntityDescriptor nativeEntityDescriptor) {
        Optional<EventDefinitionDto> eventDefinition = this.eventDefinitionService.get(nativeEntityDescriptor.id().id());
        return eventDefinition.map(eventDefinitionDto -> NativeEntity.create(nativeEntityDescriptor, eventDefinitionDto));
    }

    @Override
    public void delete(EventDefinitionDto nativeEntity) {
        this.eventDefinitionHandler.deleteImmutable(nativeEntity.id());
    }

    @Override
    public EntityExcerpt createExcerpt(EventDefinitionDto nativeEntity) {
        return ((EntityExcerpt.Builder)((EntityExcerpt.Builder)EntityExcerpt.builder().id(ModelId.of(nativeEntity.id()))).type(ModelTypes.EVENT_DEFINITION_V1)).title(nativeEntity.title()).build();
    }

    @Override
    public Set<EntityExcerpt> listEntityExcerpts() {
        return this.eventDefinitionService.streamAll().filter(ed -> ed.config().isContentPackExportable()).map(this::createExcerpt).collect(Collectors.toSet());
    }

    @Override
    public Graph<EntityDescriptor> resolveNativeEntity(EntityDescriptor entityDescriptor) {
        MutableGraph mutableGraph = GraphBuilder.directed().build();
        mutableGraph.addNode((Object)entityDescriptor);
        ModelId modelId = entityDescriptor.id();
        Optional<EventDefinitionDto> eventDefinition = this.eventDefinitionService.get(modelId.id());
        if (eventDefinition.isPresent()) {
            eventDefinition.get().resolveNativeEntity(entityDescriptor, (MutableGraph<EntityDescriptor>)mutableGraph);
        } else {
            LOG.debug("Couldn't find event definition {}", (Object)entityDescriptor);
        }
        return ImmutableGraph.copyOf((Graph)mutableGraph);
    }

    @Override
    public Graph<Entity> resolveForInstallation(Entity entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        if (entity instanceof EntityV1) {
            return this.resolveForInstallationV1((EntityV1)entity, parameters, entities);
        }
        throw new IllegalArgumentException("Unsupported entity version: " + entity.getClass());
    }

    private Graph<Entity> resolveForInstallationV1(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities) {
        MutableGraph graph = GraphBuilder.directed().build();
        graph.addNode((Object)entity);
        EventDefinitionEntity eventDefinition = (EventDefinitionEntity)this.objectMapper.convertValue((Object)entity.data(), EventDefinitionEntity.class);
        eventDefinition.resolveForInstallation(entity, parameters, entities, (MutableGraph<Entity>)graph);
        return ImmutableGraph.copyOf((Graph)graph);
    }

    @Override
    public boolean usesScopedEntities() {
        return true;
    }
}

