/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.fields.providers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.inject.assistedinject.Assisted;
import jakarta.inject.Inject;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.FieldValue;
import org.graylog.events.fields.providers.AbstractFieldValueProvider;
import org.graylog.events.fields.providers.AutoValue_LookupTableFieldValueProvider_Config;
import org.graylog.events.fields.providers.FieldValueProvider;
import org.graylog2.lookup.LookupTableService;
import org.graylog2.plugin.Message;
import org.graylog2.plugin.lookup.LookupResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LookupTableFieldValueProvider
extends AbstractFieldValueProvider {
    private static final Logger LOG = LoggerFactory.getLogger(LookupTableFieldValueProvider.class);
    private final Config config;
    private final LookupTableService lookupTableService;

    @Inject
    public LookupTableFieldValueProvider(@Assisted FieldValueProvider.Config config, LookupTableService lookupTableService) {
        super(config);
        this.config = (Config)config;
        this.lookupTableService = lookupTableService;
    }

    @Override
    protected FieldValue doGet(String fieldName, EventWithContext eventWithContext) {
        if (!this.lookupTableService.hasTable(this.config.tableName())) {
            throw new IllegalArgumentException("Lookup-table doesn't exist: " + this.config.tableName());
        }
        LookupTableService.Function function = this.lookupTableService.newBuilder().lookupTable(this.config.tableName()).build();
        if (eventWithContext.messageContext().isPresent()) {
            Message message = eventWithContext.messageContext().get();
            return this.lookup(function, message.getField(this.config.keyField()));
        }
        if (eventWithContext.eventContext().isPresent()) {
            Event event = eventWithContext.eventContext().get();
            return this.lookup(function, event.getField(this.config.keyField()).value());
        }
        throw new IllegalStateException("Neither an event nor a message context exists in event: " + eventWithContext.toString());
    }

    private FieldValue lookup(LookupTableService.Function function, Object keyValue) {
        try {
            LookupResult result = function.lookup(keyValue);
            if (result == null || result.isEmpty()) {
                return FieldValue.error();
            }
            return FieldValue.string(String.valueOf(result.singleValue()));
        }
        catch (Exception e) {
            LOG.error("Couldn't lookup value for key <{}/{}>", new Object[]{this.config.keyField(), keyValue, e});
            return FieldValue.error();
        }
    }

    @JsonTypeName(value="lookup-v1")
    @JsonDeserialize(builder=Builder.class)
    @AutoValue
    public static abstract class Config
    implements FieldValueProvider.Config {
        public static final String TYPE_NAME = "lookup-v1";
        private static final String FIELD_TABLE_NAME = "table_name";
        private static final String FIELD_KEY_FIELD = "key_field";

        @JsonProperty(value="table_name")
        public abstract String tableName();

        @JsonProperty(value="key_field")
        public abstract String keyField();

        public static Builder builder() {
            return Builder.create();
        }

        public abstract Builder toBuilder();

        @AutoValue.Builder
        public static abstract class Builder
        implements FieldValueProvider.Config.Builder<Builder> {
            @JsonCreator
            public static Builder create() {
                return new AutoValue_LookupTableFieldValueProvider_Config.Builder().type(Config.TYPE_NAME);
            }

            @JsonProperty(value="table_name")
            public abstract Builder tableName(String var1);

            @JsonProperty(value="key_field")
            public abstract Builder keyField(String var1);

            public abstract Config build();
        }
    }

    public static interface Factory
    extends AbstractFieldValueProvider.Factory<LookupTableFieldValueProvider> {
        @Override
        public LookupTableFieldValueProvider create(FieldValueProvider.Config var1);
    }
}

