/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.legacy;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.graylog.events.contentpack.entities.EventNotificationConfigEntity;
import org.graylog.events.contentpack.entities.LegacyAlarmCallbackEventNotificationConfigEntity;
import org.graylog.events.event.EventDto;
import org.graylog.events.legacy.AutoValue_LegacyAlarmCallbackEventNotificationConfig;
import org.graylog.events.notifications.EventNotificationConfig;
import org.graylog.events.notifications.EventNotificationExecutionJob;
import org.graylog.scheduler.JobTriggerData;
import org.graylog2.contentpacks.EntityDescriptorIds;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.rest.ValidationResult;

@JsonTypeName(value="legacy-alarm-callback-notification-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class LegacyAlarmCallbackEventNotificationConfig
implements EventNotificationConfig {
    public static final String TYPE_NAME = "legacy-alarm-callback-notification-v1";
    private static final String FIELD_CALLBACK_TYPE = "callback_type";
    private static final String FIELD_CONFIGURATION = "configuration";

    @JsonProperty(value="callback_type")
    public abstract String callbackType();

    @JsonProperty(value="configuration")
    public abstract Map<String, Object> configuration();

    @Override
    @JsonIgnore
    public JobTriggerData toJobTriggerData(EventDto dto) {
        return EventNotificationExecutionJob.Data.builder().eventDto(dto).build();
    }

    public static Builder builder() {
        return Builder.create();
    }

    @Override
    @JsonIgnore
    public ValidationResult validate() {
        ValidationResult validation = new ValidationResult();
        if (this.callbackType().isEmpty()) {
            validation.addError(FIELD_CALLBACK_TYPE, "Legacy Notification callback type cannot be empty.");
        }
        return validation;
    }

    @Override
    public EventNotificationConfigEntity toContentPackEntity(EntityDescriptorIds entityDescriptorIds) {
        return LegacyAlarmCallbackEventNotificationConfigEntity.builder().callbackType(ValueReference.of(this.callbackType())).configuration(this.configuration()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventNotificationConfig.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_LegacyAlarmCallbackEventNotificationConfig.Builder().type(LegacyAlarmCallbackEventNotificationConfig.TYPE_NAME);
        }

        @JsonProperty(value="callback_type")
        public abstract Builder callbackType(String var1);

        @JsonProperty(value="configuration")
        public abstract Builder configuration(Map<String, Object> var1);

        public abstract LegacyAlarmCallbackEventNotificationConfig build();
    }
}

